"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const string_parameter_1 = require("./string-parameter");
// export CDK_DEFAULT_REGION=us-east-1
// export CDK_DEFAULT_ACCOUNT=123456789012
// cdk deploy --app 'npx ts-node -P tsconfig.json --prefer-ts-exts ./src/integ.default.ts'
const app = new aws_cdk_lib_1.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new aws_cdk_lib_1.Stack(app, "SsmParameterCrossRegionIntegrationTest", { env: env });
const putParameter = new string_parameter_1.StringParameter(stack, "PutParameter", {
    region: "eu-central-1",
    parameterName: "/path/name/integ/test",
    stringValue: "Say hello from another region",
});
const getParameter = string_parameter_1.StringParameter.fromStringParameterName(stack, "GetParameter", "eu-central-1", "/path/name/integ/test");
getParameter.node.addDependency(putParameter);
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkNBQXNEO0FBQ3RELHlEQUFxRDtBQUVyRCxzQ0FBc0M7QUFDdEMsMENBQTBDO0FBQzFDLDBGQUEwRjtBQUUxRixNQUFNLEdBQUcsR0FBRyxJQUFJLGlCQUFHLEVBQUUsQ0FBQztBQUV0QixNQUFNLEdBQUcsR0FBZ0I7SUFDdkIsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCO0lBQ3RDLE9BQU8sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUFtQjtDQUN6QyxDQUFDO0FBRUYsTUFBTSxLQUFLLEdBQUcsSUFBSSxtQkFBSyxDQUFDLEdBQUcsRUFBRSx3Q0FBd0MsRUFBRSxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO0FBRXJGLE1BQU0sWUFBWSxHQUFHLElBQUksa0NBQWUsQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFO0lBQzlELE1BQU0sRUFBRSxjQUFjO0lBQ3RCLGFBQWEsRUFBRSx1QkFBdUI7SUFDdEMsV0FBVyxFQUFFLCtCQUErQjtDQUM3QyxDQUFDLENBQUM7QUFDSCxNQUFNLFlBQVksR0FBRyxrQ0FBZSxDQUFDLHVCQUF1QixDQUMxRCxLQUFLLEVBQ0wsY0FBYyxFQUNkLGNBQWMsRUFDZCx1QkFBdUIsQ0FDeEIsQ0FBQztBQUNGLFlBQVksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxDQUFDO0FBRTlDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgRW52aXJvbm1lbnQsIFN0YWNrIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBTdHJpbmdQYXJhbWV0ZXIgfSBmcm9tIFwiLi9zdHJpbmctcGFyYW1ldGVyXCI7XG5cbi8vIGV4cG9ydCBDREtfREVGQVVMVF9SRUdJT049dXMtZWFzdC0xXG4vLyBleHBvcnQgQ0RLX0RFRkFVTFRfQUNDT1VOVD0xMjM0NTY3ODkwMTJcbi8vIGNkayBkZXBsb3kgLS1hcHAgJ25weCB0cy1ub2RlIC1QIHRzY29uZmlnLmpzb24gLS1wcmVmZXItdHMtZXh0cyAuL3NyYy9pbnRlZy5kZWZhdWx0LnRzJ1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbmNvbnN0IGVudjogRW52aXJvbm1lbnQgPSB7XG4gIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfUkVHSU9OLFxuICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxufTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBcIlNzbVBhcmFtZXRlckNyb3NzUmVnaW9uSW50ZWdyYXRpb25UZXN0XCIsIHsgZW52OiBlbnYgfSk7XG5cbmNvbnN0IHB1dFBhcmFtZXRlciA9IG5ldyBTdHJpbmdQYXJhbWV0ZXIoc3RhY2ssIFwiUHV0UGFyYW1ldGVyXCIsIHtcbiAgcmVnaW9uOiBcImV1LWNlbnRyYWwtMVwiLFxuICBwYXJhbWV0ZXJOYW1lOiBcIi9wYXRoL25hbWUvaW50ZWcvdGVzdFwiLFxuICBzdHJpbmdWYWx1ZTogXCJTYXkgaGVsbG8gZnJvbSBhbm90aGVyIHJlZ2lvblwiLFxufSk7XG5jb25zdCBnZXRQYXJhbWV0ZXIgPSBTdHJpbmdQYXJhbWV0ZXIuZnJvbVN0cmluZ1BhcmFtZXRlck5hbWUoXG4gIHN0YWNrLFxuICBcIkdldFBhcmFtZXRlclwiLFxuICBcImV1LWNlbnRyYWwtMVwiLFxuICBcIi9wYXRoL25hbWUvaW50ZWcvdGVzdFwiXG4pO1xuZ2V0UGFyYW1ldGVyLm5vZGUuYWRkRGVwZW5kZW5jeShwdXRQYXJhbWV0ZXIpO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==