import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Synthetics::Canary`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export interface CfnCanaryProps {
    /**
     * `AWS::Synthetics::Canary.ArtifactS3Location`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location
     */
    readonly artifactS3Location: string;
    /**
     * `AWS::Synthetics::Canary.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code
     */
    readonly code: CfnCanary.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::Synthetics::Canary.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name
     */
    readonly name: string;
    /**
     * `AWS::Synthetics::Canary.RuntimeVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion
     */
    readonly runtimeVersion: string;
    /**
     * `AWS::Synthetics::Canary.Schedule`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule
     */
    readonly schedule: CfnCanary.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.StartCanaryAfterCreation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation
     */
    readonly startCanaryAfterCreation: boolean | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.FailureRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod
     */
    readonly failureRetentionPeriod?: number;
    /**
     * `AWS::Synthetics::Canary.RunConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig
     */
    readonly runConfig?: CfnCanary.RunConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.SuccessRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod
     */
    readonly successRetentionPeriod?: number;
    /**
     * `AWS::Synthetics::Canary.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Synthetics::Canary.VPCConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig
     */
    readonly vpcConfig?: CfnCanary.VPCConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`
 *
 * @cloudformationResource AWS::Synthetics::Canary
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export declare class CfnCanary extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Synthetics::Canary";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCanary;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::Synthetics::Canary.ArtifactS3Location`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location
     */
    artifactS3Location: string;
    /**
     * `AWS::Synthetics::Canary.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code
     */
    code: CfnCanary.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn
     */
    executionRoleArn: string;
    /**
     * `AWS::Synthetics::Canary.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name
     */
    name: string;
    /**
     * `AWS::Synthetics::Canary.RuntimeVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion
     */
    runtimeVersion: string;
    /**
     * `AWS::Synthetics::Canary.Schedule`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule
     */
    schedule: CfnCanary.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.StartCanaryAfterCreation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation
     */
    startCanaryAfterCreation: boolean | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.FailureRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod
     */
    failureRetentionPeriod: number | undefined;
    /**
     * `AWS::Synthetics::Canary.RunConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig
     */
    runConfig: CfnCanary.RunConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Synthetics::Canary.SuccessRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod
     */
    successRetentionPeriod: number | undefined;
    /**
     * `AWS::Synthetics::Canary.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Synthetics::Canary.VPCConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig
     */
    vpcConfig: CfnCanary.VPCConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Synthetics::Canary`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCanaryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCanary {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html
     */
    interface CodeProperty {
        /**
         * `CfnCanary.CodeProperty.Handler`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-handler
         */
        readonly handler?: string;
        /**
         * `CfnCanary.CodeProperty.S3Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3bucket
         */
        readonly s3Bucket?: string;
        /**
         * `CfnCanary.CodeProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3key
         */
        readonly s3Key?: string;
        /**
         * `CfnCanary.CodeProperty.S3ObjectVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3objectversion
         */
        readonly s3ObjectVersion?: string;
        /**
         * `CfnCanary.CodeProperty.Script`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-script
         */
        readonly script?: string;
    }
}
export declare namespace CfnCanary {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html
     */
    interface RunConfigProperty {
        /**
         * `CfnCanary.RunConfigProperty.MemoryInMB`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-memoryinmb
         */
        readonly memoryInMb?: number;
        /**
         * `CfnCanary.RunConfigProperty.TimeoutInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-timeoutinseconds
         */
        readonly timeoutInSeconds: number;
    }
}
export declare namespace CfnCanary {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnCanary.ScheduleProperty.DurationInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-durationinseconds
         */
        readonly durationInSeconds?: string;
        /**
         * `CfnCanary.ScheduleProperty.Expression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-expression
         */
        readonly expression: string;
    }
}
export declare namespace CfnCanary {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html
     */
    interface VPCConfigProperty {
        /**
         * `CfnCanary.VPCConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnCanary.VPCConfigProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-subnetids
         */
        readonly subnetIds: string[];
        /**
         * `CfnCanary.VPCConfigProperty.VpcId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-vpcid
         */
        readonly vpcId?: string;
    }
}
