"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46.   # noqa: E501

    The version of the OpenAPI document: 22.9.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from symphony.bdk.gen.api_client import ApiClient, Endpoint as _Endpoint
from symphony.bdk.gen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from symphony.bdk.gen.agent_model.error import Error
from symphony.bdk.gen.agent_model.v1_dlp_violation_message_response import V1DLPViolationMessageResponse
from symphony.bdk.gen.agent_model.v1_dlp_violation_signal_response import V1DLPViolationSignalResponse
from symphony.bdk.gen.agent_model.v1_dlp_violation_stream_response import V1DLPViolationStreamResponse
from symphony.bdk.gen.agent_model.v3_dlp_violation_message_response import V3DLPViolationMessageResponse
from symphony.bdk.gen.agent_model.v3_dlp_violation_signal_response import V3DLPViolationSignalResponse
from symphony.bdk.gen.agent_model.v3_dlp_violation_stream_response import V3DLPViolationStreamResponse


class ViolationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_dlp_violations_message_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPViolationMessageResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/violations/message',
                'operation_id': 'v1_dlp_violations_message_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                    'end_time',
                    'next',
                    'limit',
                ],
                'required': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_time':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'end_time':
                        (int,),
                    'next':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'start_time': 'startTime',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'end_time': 'endTime',
                    'next': 'next',
                    'limit': 'limit',
                },
                'location_map': {
                    'start_time': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'end_time': 'query',
                    'next': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_violations_signal_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPViolationSignalResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/violations/signal',
                'operation_id': 'v1_dlp_violations_signal_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                    'end_time',
                    'next',
                    'limit',
                ],
                'required': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_time':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'end_time':
                        (int,),
                    'next':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'start_time': 'startTime',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'end_time': 'endTime',
                    'next': 'next',
                    'limit': 'limit',
                },
                'location_map': {
                    'start_time': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'end_time': 'query',
                    'next': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_violations_stream_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPViolationStreamResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/violations/stream',
                'operation_id': 'v1_dlp_violations_stream_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                    'end_time',
                    'next',
                    'limit',
                ],
                'required': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_time':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'end_time':
                        (int,),
                    'next':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'start_time': 'startTime',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'end_time': 'endTime',
                    'next': 'next',
                    'limit': 'limit',
                },
                'location_map': {
                    'start_time': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'end_time': 'query',
                    'next': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_violation_attachment_get_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v3/dlp/violation/attachment',
                'operation_id': 'v3_dlp_violation_attachment_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'file_id',
                    'violation_id',
                    'session_token',
                    'key_manager_token',
                ],
                'required': [
                    'file_id',
                    'violation_id',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'file_id':
                        (str,),
                    'violation_id':
                        (str,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                },
                'attribute_map': {
                    'file_id': 'fileId',
                    'violation_id': 'violationId',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'file_id': 'query',
                    'violation_id': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/octet-stream'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_violations_message_get_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPViolationMessageResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/violations/message',
                'operation_id': 'v3_dlp_violations_message_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                    'end_time',
                    'next',
                    'limit',
                ],
                'required': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_time':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'end_time':
                        (int,),
                    'next':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'start_time': 'startTime',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'end_time': 'endTime',
                    'next': 'next',
                    'limit': 'limit',
                },
                'location_map': {
                    'start_time': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'end_time': 'query',
                    'next': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_violations_signal_get_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPViolationSignalResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/violations/signal',
                'operation_id': 'v3_dlp_violations_signal_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                    'end_time',
                    'next',
                    'limit',
                ],
                'required': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_time':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'end_time':
                        (int,),
                    'next':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'start_time': 'startTime',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'end_time': 'endTime',
                    'next': 'next',
                    'limit': 'limit',
                },
                'location_map': {
                    'start_time': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'end_time': 'query',
                    'next': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_violations_stream_get_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPViolationStreamResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/violations/stream',
                'operation_id': 'v3_dlp_violations_stream_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                    'end_time',
                    'next',
                    'limit',
                ],
                'required': [
                    'start_time',
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_time':
                        (int,),
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'end_time':
                        (int,),
                    'next':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'start_time': 'startTime',
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'end_time': 'endTime',
                    'next': 'next',
                    'limit': 'limit',
                },
                'location_map': {
                    'start_time': 'query',
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'end_time': 'query',
                    'next': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def v1_dlp_violations_message_get(
        self,
        start_time,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get violations as a result of policy enforcement on messages.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_violations_message_get(start_time, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            start_time (int): Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            end_time (int): Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. . [optional]
            next (str): Offset of the next chunk of violations. Value is null for the first request.. [optional]
            limit (int): Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPViolationMessageResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_time'] = \
            start_time
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v1_dlp_violations_message_get_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_violations_signal_get(
        self,
        start_time,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get violations as a result of policy enforcement on signals.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_violations_signal_get(start_time, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            start_time (int): Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            end_time (int): Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. . [optional]
            next (str): Offset of the next chunk of violations. Value is null for the first request.. [optional]
            limit (int): Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPViolationSignalResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_time'] = \
            start_time
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v1_dlp_violations_signal_get_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_violations_stream_get(
        self,
        start_time,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get violations as a result of policy enforcement on streams.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_violations_stream_get(start_time, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            start_time (int): Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            end_time (int): Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. . [optional]
            next (str): Offset of the next chunk of violations. Value is null for the first request.. [optional]
            limit (int): Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPViolationStreamResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_time'] = \
            start_time
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v1_dlp_violations_stream_get_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_violation_attachment_get(
        self,
        file_id,
        violation_id,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get attachments that were sent as part of messages that were flagged by the DLP System.  # noqa: E501

        Retrieves attachments from related message violations as a base64 encoded String.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_violation_attachment_get(file_id, violation_id, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            file_id (str): ID of attachment that will be downloaded.
            violation_id (str): ID of violation that corresponds to the flagged message that contains the attachment
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['file_id'] = \
            file_id
        kwargs['violation_id'] = \
            violation_id
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v3_dlp_violation_attachment_get_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_violations_message_get(
        self,
        start_time,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get violations as a result of policy enforcement on messages.  # noqa: E501

        Retrieves DLP v3 message related violations for a given time range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_violations_message_get(start_time, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            start_time (int): Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            end_time (int): Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. . [optional]
            next (str): Offset of the next chunk of violations. Value is null for the first request.. [optional]
            limit (int): Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPViolationMessageResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_time'] = \
            start_time
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v3_dlp_violations_message_get_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_violations_signal_get(
        self,
        start_time,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get violations as a result of policy enforcement on signals.  # noqa: E501

        Retrieves DLP v3 signal related violations for a given time range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_violations_signal_get(start_time, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            start_time (int): Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            end_time (int): Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. . [optional]
            next (str): Offset of the next chunk of violations. Value is null for the first request.. [optional]
            limit (int): Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPViolationSignalResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_time'] = \
            start_time
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v3_dlp_violations_signal_get_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_violations_stream_get(
        self,
        start_time,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get violations as a result of policy enforcement on streams.  # noqa: E501

        Retrieves DLP v3 signal related violations for a given time range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_violations_stream_get(start_time, session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            start_time (int): Timestamp of the first required violation. This is a long integer value representing milliseconds since Jan 1 1970 
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            end_time (int): Timestamp of the last required violation. This is a long integer value representing milliseconds since Jan 1 1970 If unspecified, it will default to current time of the request. . [optional]
            next (str): Offset of the next chunk of violations. Value is null for the first request.. [optional]
            limit (int): Max No. of violations to return. If no value is provided, 50 is the default. The maximum supported value is 500. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPViolationStreamResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_time'] = \
            start_time
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v3_dlp_violations_stream_get_endpoint.call_with_http_info(**kwargs)

