"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'mappings can be added as another type of entity, and mapping.findInMap can be used to get a token'(test) {
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'MyMapping', {
            mapping: {
                TopLevelKey1: {
                    SecondLevelKey1: [1, 2, 3],
                    SecondLevelKey2: { Hello: 'World' },
                },
                TopLevelKey2: {
                    SecondLevelKey1: [99, 99, 99],
                },
            },
        });
        // findInMap can be used to take a reference
        new lib_1.CfnResource(stack, 'MyResource', {
            type: 'R',
            properties: {
                RefToValueInMap: mapping.findInMap('TopLevelKey1', 'SecondLevelKey1'),
            },
        });
        test.throws(() => mapping.findInMap('NotFoundTopLevel', 'NotFound'), 'cant take a reference on a non existing key');
        test.throws(() => mapping.findInMap('TopLevelKey1', 'NotFound'), 'cant take a reference on a non existing key');
        // set value can be used to set/modify a specific value
        mapping.setValue('TopLevelKey2', 'SecondLevelKey2', 'Hi');
        mapping.setValue('TopLevelKey1', 'SecondLevelKey1', [1, 2, 3, 4]);
        test.deepEqual(util_1.toCloudFormation(stack), {
            Mappings: {
                MyMapping: {
                    TopLevelKey1: {
                        SecondLevelKey1: [1, 2, 3, 4],
                        SecondLevelKey2: { Hello: 'World' },
                    },
                    TopLevelKey2: { SecondLevelKey1: [99, 99, 99], SecondLevelKey2: 'Hi' },
                },
            },
            Resources: {
                MyResource: {
                    Type: 'R',
                    Properties: {
                        RefToValueInMap: { 'Fn::FindInMap': ['MyMapping', 'TopLevelKey1', 'SecondLevelKey1'] },
                    },
                },
            },
        });
        test.done();
    },
    'allow using unresolved tokens in find-in-map'(test) {
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                instanceCount: {
                    'us-east-1': 12,
                },
            },
        });
        const v1 = mapping.findInMap('instanceCount', lib_1.Aws.REGION);
        const v2 = lib_1.Fn.findInMap(mapping.logicalId, 'instanceCount', lib_1.Aws.REGION);
        const expected = { 'Fn::FindInMap': ['mapping', 'instanceCount', { Ref: 'AWS::Region' }] };
        test.deepEqual(stack.resolve(v1), expected);
        test.deepEqual(stack.resolve(v2), expected);
        test.done();
    },
    'no validation if first key is token and second is a static string'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                'us-east-1': {
                    size: 12,
                },
            },
        });
        // WHEN
        const v = mapping.findInMap(lib_1.Aws.REGION, 'size');
        // THEN
        test.deepEqual(stack.resolve(v), {
            'Fn::FindInMap': ['mapping', { Ref: 'AWS::Region' }, 'size'],
        });
        test.done();
    },
    'validate first key if it is a string and second is a token'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                size: {
                    'us-east-1': 12,
                },
            },
        });
        // WHEN
        const v = mapping.findInMap('size', lib_1.Aws.REGION);
        // THEN
        test.throws(() => mapping.findInMap('not-found', lib_1.Aws.REGION), /Mapping doesn't contain top-level key 'not-found'/);
        test.deepEqual(stack.resolve(v), { 'Fn::FindInMap': ['mapping', 'size', { Ref: 'AWS::Region' }] });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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