"use strict";
const lib_1 = require("../lib");
module.exports = {
    'valueAsString supports both string and number types'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const numberParam = new lib_1.CfnParameter(stack, 'numberParam', { type: 'Number', default: 10 });
        const stringParam = new lib_1.CfnParameter(stack, 'stringParam', { type: 'String', default: 'a-default' });
        // WHEN
        const numVal = numberParam.valueAsString;
        const strVal = stringParam.valueAsString;
        // THEN
        test.deepEqual(stack.resolve(numVal), { Ref: 'numberParam' });
        test.deepEqual(stack.resolve(strVal), { Ref: 'stringParam' });
        test.done();
    },
    'valueAsString fails for unsupported types'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const listParam = new lib_1.CfnParameter(stack, 'listParam', { type: 'List', default: 10 });
        // WHEN - THEN
        test.throws(() => listParam.valueAsList, /Parameter type \(List\)/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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