"use strict";
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const lib_1 = require("../lib");
const aspect_1 = require("../lib/aspect");
const construct_compat_1 = require("../lib/construct-compat");
class MyConstruct extends construct_compat_1.Construct {
    constructor() {
        super(...arguments);
        this.visitCounter = 0;
    }
    static IsMyConstruct(x) {
        return x.visitCounter !== undefined;
    }
}
class VisitOnce {
    visit(node) {
        if (MyConstruct.IsMyConstruct(node)) {
            node.visitCounter += 1;
        }
    }
}
class MyAspect {
    visit(node) {
        node.node.addMetadata('foo', 'bar');
    }
}
module.exports = {
    'Aspects are invoked only once'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'MyConstruct');
        aspect_1.Aspects.of(root).add(new VisitOnce());
        app.synth();
        test.deepEqual(root.visitCounter, 1);
        app.synth();
        test.deepEqual(root.visitCounter, 1);
        test.done();
    },
    'Warn if an Aspect is added via another Aspect'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'MyConstruct');
        const child = new MyConstruct(root, 'ChildConstruct');
        aspect_1.Aspects.of(root).add({
            visit(construct) {
                aspect_1.Aspects.of(construct).add({
                    visit(inner) {
                        inner.node.addMetadata('test', 'would-be-ignored');
                    },
                });
            },
        });
        app.synth();
        test.deepEqual(root.node.metadata[0].type, cxschema.ArtifactMetadataEntryType.WARN);
        test.deepEqual(root.node.metadata[0].data, 'We detected an Aspect was added via another Aspect, and will not be applied');
        // warning is not added to child construct
        test.equal(child.node.metadata.length, 0);
        test.done();
    },
    'Do not warn if an Aspect is added directly (not by another aspect)'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'Construct');
        const child = new MyConstruct(root, 'ChildConstruct');
        aspect_1.Aspects.of(root).add(new MyAspect());
        app.synth();
        test.deepEqual(root.node.metadata[0].type, 'foo');
        test.deepEqual(root.node.metadata[0].data, 'bar');
        test.deepEqual(root.node.metadata[0].type, 'foo');
        test.deepEqual(child.node.metadata[0].data, 'bar');
        // no warning is added
        test.equal(root.node.metadata.length, 1);
        test.equal(child.node.metadata.length, 1);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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