"use strict";
const fs = require("fs");
const os = require("os");
const path = require("path");
const sinon = require("sinon");
const fs_1 = require("../../lib/fs");
module.exports = {
    'tearDown'(callback) {
        sinon.restore();
        callback();
    },
    'tmpdir returns a real path and is cached'(test) {
        // Create symlink that points to /tmp
        const symlinkTmp = path.join(__dirname, 'tmp-link');
        fs.symlinkSync(os.tmpdir(), symlinkTmp);
        // Now stub os.tmpdir() to return this link instead of /tmp
        const tmpdirStub = sinon.stub(os, 'tmpdir').returns(symlinkTmp);
        test.ok(path.isAbsolute(fs_1.FileSystem.tmpdir));
        const p = path.join(fs_1.FileSystem.tmpdir, 'tmpdir-test.txt');
        fs.writeFileSync(p, 'tmpdir-test');
        test.equal(p, fs.realpathSync(p));
        test.equal(fs.readFileSync(p, 'utf8'), 'tmpdir-test');
        // check that tmpdir() is called either 0 times (in which case it was
        // proabably cached from before) or once (for this test).
        test.ok(tmpdirStub.callCount < 2);
        fs.unlinkSync(p);
        fs.unlinkSync(symlinkTmp);
        test.done();
    },
    'mkdtemp creates a temporary directory in the system temp'(test) {
        const tmpdir = fs_1.FileSystem.mkdtemp('cdk-mkdtemp-');
        test.equal(path.dirname(tmpdir), fs_1.FileSystem.tmpdir);
        test.ok(fs.existsSync(tmpdir));
        fs.rmdirSync(tmpdir);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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