"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackSynthesizer = void 0;
const _shared_1 = require("./_shared");
/**
 * Base class for implementing an IStackSynthesizer
 *
 * This class needs to exist to provide public surface area for external
 * implementations of stack synthesizers. The protected methods give
 * access to functions that are otherwise @_internal to the framework
 * and could not be accessed by external implementors.
 */
class StackSynthesizer {
    /**
     * Have the stack write out its template
     */
    synthesizeStackTemplate(stack, session) {
        stack._synthesizeTemplate(session);
    }
    /**
     * Write the stack artifact to the session
     *
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     */
    emitStackArtifact(stack, session, options = {}) {
        var _a;
        _shared_1.addStackArtifactToAssembly(session, stack, options !== null && options !== void 0 ? options : {}, (_a = options.additionalDependencies) !== null && _a !== void 0 ? _a : []);
    }
}
exports.StackSynthesizer = StackSynthesizer;
//# sourceMappingURL=data:application/json;base64,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