"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SymlinkFollowMode = void 0;
/**
 * Determines how symlinks are followed.
 */
var SymlinkFollowMode;
(function (SymlinkFollowMode) {
    /**
     * Never follow symlinks.
     */
    SymlinkFollowMode["NEVER"] = "never";
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    SymlinkFollowMode["ALWAYS"] = "always";
    /**
     * Only follows symlinks that are external to the source directory.
     */
    SymlinkFollowMode["EXTERNAL"] = "external";
    /**
     * Forbids source from having any symlinks pointing outside of the source
     * tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     */
    SymlinkFollowMode["BLOCK_EXTERNAL"] = "internal-only";
})(SymlinkFollowMode = exports.SymlinkFollowMode || (exports.SymlinkFollowMode = {}));
//# sourceMappingURL=data:application/json;base64,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