"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureFlags = void 0;
const cxapi = require("@aws-cdk/cx-api");
/**
 * Features that are implemented behind a flag in order to preserve backwards
 * compatibility for existing apps. The list of flags are available in the
 * `@aws-cdk/cx-api` module.
 *
 * The state of the flag for this application is stored as a CDK context variable.
 */
class FeatureFlags {
    constructor(construct) {
        this.construct = construct;
    }
    /**
     * Inspect feature flags on the construct node's context.
     */
    static of(scope) {
        return new FeatureFlags(scope);
    }
    /**
     * Check whether a feature flag is enabled. If configured, the flag is present in
     * the construct node context. Falls back to the defaults defined in the `cx-api`
     * module.
     */
    isEnabled(featureFlag) {
        var _a;
        return (_a = this.construct.node.tryGetContext(featureFlag)) !== null && _a !== void 0 ? _a : cxapi.futureFlagDefault(featureFlag);
    }
}
exports.FeatureFlags = FeatureFlags;
//# sourceMappingURL=data:application/json;base64,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