"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileAssetPackaging = exports.AssetHashType = void 0;
/**
 * The type of asset hash
 *
 * NOTE: the hash is used in order to identify a specific revision of the asset, and
 * used for optimizing and caching deployment activities related to this asset such as
 * packaging, uploading to Amazon S3, etc.
 */
var AssetHashType;
(function (AssetHashType) {
    /**
     * Based on the content of the source path
     *
     * When bundling, use `SOURCE` when the content of the bundling output is not
     * stable across repeated bundling operations.
     */
    AssetHashType["SOURCE"] = "source";
    /**
     * Based on the content of the bundled path
     *
     * @deprecated use `OUTPUT` instead
     */
    AssetHashType["BUNDLE"] = "bundle";
    /**
     * Based on the content of the bundling output
     *
     * Use `OUTPUT` when the source of the asset is a top level folder containing
     * code and/or dependencies that are not directly linked to the asset.
     */
    AssetHashType["OUTPUT"] = "output";
    /**
     * Use a custom hash
     */
    AssetHashType["CUSTOM"] = "custom";
})(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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