# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
from datetime import datetime

# Local
from .core_texts import license
from .utils import multi_replace

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------------ Public methods ------------------------------------------------------------ #

def new_license(package_name: str) -> str:
    return multi_replace(
        license,
        {
            '[YEAR]': datetime.utcnow().year,
            '[PACKAGE_NAME]': package_name
        }
    )

# ---------------------------------------------------------------------------------------------------------------------------------------- #
