"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lambdaHandler = void 0;
var AWS = require('aws-sdk');
const lambda = new AWS.Lambda();
const targetFunctionName = process.env.TARGET_FN_NAME;
exports.lambdaHandler = async (event) => {
    const index = event.iterator.index + 1;
    const params = {
        FunctionName: targetFunctionName,
        InvocationType: 'Event',
    };
    lambda.invoke(params, function (error) {
        if (error) {
            console.log(error, error.stack);
        }
        else {
            console.log('The target function is triggered.');
        }
    });
    return {
        index: index,
        continue: index < event.iterator.count,
        count: event.iterator.count,
    };
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaXRlcmF0b3JfYWdlbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcmVzb3VyY2VzL2l0ZXJhdG9yL2l0ZXJhdG9yX2FnZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLElBQUksR0FBRyxHQUFHLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQztBQUM3QixNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztBQUVoQyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDO0FBRXpDLFFBQUEsYUFBYSxHQUFHLEtBQUssRUFBRSxLQUFVLEVBQWdCLEVBQUU7SUFDOUQsTUFBTSxLQUFLLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO0lBQ3ZDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsWUFBWSxFQUFFLGtCQUFrQjtRQUNoQyxjQUFjLEVBQUUsT0FBTztLQUN4QixDQUFDO0lBQ0YsTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsVUFBVSxLQUFVO1FBQ3hDLElBQUksS0FBSyxFQUFFO1lBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQUU7YUFBTTtZQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUNBQW1DLENBQUMsQ0FBQztTQUFFO0lBRTVHLENBQUMsQ0FBQyxDQUFDO0lBQ0gsT0FBTztRQUNMLEtBQUssRUFBRSxLQUFLO1FBQ1osUUFBUSxFQUFFLEtBQUssR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUs7UUFDdEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsS0FBSztLQUM1QixDQUFDO0FBQ0osQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsidmFyIEFXUyA9IHJlcXVpcmUoJ2F3cy1zZGsnKTtcbmNvbnN0IGxhbWJkYSA9IG5ldyBBV1MuTGFtYmRhKCk7XG5cbmNvbnN0IHRhcmdldEZ1bmN0aW9uTmFtZSA9IHByb2Nlc3MuZW52LlRBUkdFVF9GTl9OQU1FO1xuXG5leHBvcnQgY29uc3QgbGFtYmRhSGFuZGxlciA9IGFzeW5jIChldmVudDogYW55KTogUHJvbWlzZTxhbnk+ID0+IHtcbiAgY29uc3QgaW5kZXggPSBldmVudC5pdGVyYXRvci5pbmRleCArIDE7XG4gIGNvbnN0IHBhcmFtcyA9IHtcbiAgICBGdW5jdGlvbk5hbWU6IHRhcmdldEZ1bmN0aW9uTmFtZSxcbiAgICBJbnZvY2F0aW9uVHlwZTogJ0V2ZW50JyxcbiAgfTtcbiAgbGFtYmRhLmludm9rZShwYXJhbXMsIGZ1bmN0aW9uIChlcnJvcjogYW55KSB7XG4gICAgaWYgKGVycm9yKSB7IGNvbnNvbGUubG9nKGVycm9yLCBlcnJvci5zdGFjayk7IH0gZWxzZSB7IGNvbnNvbGUubG9nKCdUaGUgdGFyZ2V0IGZ1bmN0aW9uIGlzIHRyaWdnZXJlZC4nKTsgfVxuXG4gIH0pO1xuICByZXR1cm4ge1xuICAgIGluZGV4OiBpbmRleCxcbiAgICBjb250aW51ZTogaW5kZXggPCBldmVudC5pdGVyYXRvci5jb3VudCxcbiAgICBjb3VudDogZXZlbnQuaXRlcmF0b3IuY291bnQsXG4gIH07XG59OyJdfQ==