# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.2
from typing_extensions import Literal
from .native_number_xml_attributes import NativeNumberXmlAttributes as NativeNumberXmlAttributes_5e4f1070
from ..lang.locale import Locale as Locale_70d308fa
import typing


class NativeNumberXmlAttributes2(NativeNumberXmlAttributes_5e4f1070):
    """
    Struct Class

    Attributes describing a native number mode for a specific locale, stored in XML file format.
    
    Used later with XNativeNumberSupplier2.convertToXmlAttributes() and XNativeNumberSupplier2.convertFromXmlAttributes()
    
    **since**
    
        LibreOffice 6.1

    See Also:
        `API NativeNumberXmlAttributes2 <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1NativeNumberXmlAttributes2.html>`_
    """
    typeName: Literal['com.sun.star.i18n.NativeNumberXmlAttributes2']

    def __init__(self, Locale: typing.Optional[Locale_70d308fa] = ..., Format: typing.Optional[str] = ..., Style: typing.Optional[str] = ..., Spellout: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            Locale (Locale, optional): Locale value.
            Format (str, optional): Format value.
            Style (str, optional): Style value.
            Spellout (str, optional): Spellout value.
        """
        ...


    @property
    def Spellout(self) -> str:
        """
        The format of the number string, for example, \"cardinal\", \"ordinal\" or \"ordinal-number\".
        """
        ...


