# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.datatransfer.dnd
# Libre Office Version: 7.2
from typing_extensions import Literal
from .drop_target_event import DropTargetEvent as DropTargetEvent_8d651169
from ...uno.x_interface import XInterface as XInterface_8f010a43
import typing
from .x_drop_target_drag_context import XDropTargetDragContext as XDropTargetDragContext_10221422


class DropTargetDragEvent(DropTargetEvent_8d651169):
    """
    Struct Class

    The DropTargetDragEvent is delivered from the drop target to the currently registered drop target listener.
    
    It contains information regarding the current state of the operation to enable the operations initiator to provide the end user with the appropriate drag over feedback.

    See Also:
        `API DropTargetDragEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1datatransfer_1_1dnd_1_1DropTargetDragEvent.html>`_
    """
    typeName: Literal['com.sun.star.datatransfer.dnd.DropTargetDragEvent']

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = ..., Dummy: typing.Optional[int] = ..., Context: typing.Optional[XDropTargetDragContext_10221422] = ..., DropAction: typing.Optional[int] = ..., LocationX: typing.Optional[int] = ..., LocationY: typing.Optional[int] = ..., SourceActions: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Dummy (int, optional): Dummy value.
            Context (XDropTargetDragContext, optional): Context value.
            DropAction (int, optional): DropAction value.
            LocationX (int, optional): LocationX value.
            LocationY (int, optional): LocationY value.
            SourceActions (int, optional): SourceActions value.
        """
        ...


    @property
    def Context(self) -> XDropTargetDragContext_10221422:
        """
        The drop target context of the current drag operation.
        """
        ...


    @property
    def DropAction(self) -> int:
        """
        This value represents the currently selected drop action.
        """
        ...


    @property
    def LocationX(self) -> int:
        """
        The cursor's current x location within the window's coordinates.
        """
        ...


    @property
    def LocationY(self) -> int:
        """
        The cursor's current y location within the window's coordinates.
        """
        ...


    @property
    def SourceActions(self) -> int:
        """
        This value represents the action or actions supported by the source.
        
        This may be a combination of arbitrary source actions except ACTION_DEFAULT.
        
        To combine different actions use a logical OR.
        """
        ...


