# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.beans
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .property import Property as Property_8f4e0a76
    from ..reflection.x_idl_method import XIdlMethod as XIdlMethod_e3740d05

class XIntrospectionAccess(XInterface_8f010a43):
    """
    represents the result of an introspection operation done by the inspect method of XIntrospection.
    
    This interface gives information about an object's properties and methods as detected in the introspection process. It's not possible to access properties or call methods directly using this interface but it provides access to other interfaces to do so. See com.sun.star.beans.XIntrospectionAccess.queryAdapter()
    
    The XExactName interface has to be supported in order to implement inaccurate name access for all objects which implement the com.sun.star.container.XNameAccess interface or XPropertySet.
    
    The XMaterialHolder interface has to be supported to give access to the inspected object.

    See Also:
        `API XIntrospectionAccess <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1beans_1_1XIntrospectionAccess.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.beans.XIntrospectionAccess']

    def getMethod(self, aName: str, nMethodConcepts: int) -> 'XIdlMethod_e3740d05':
        """
        returns information about a method if a method with the demanded name exists and if it accords to one of the demanded MethodConcepts.
        
        The information is provided as com.sun.star.reflection.XIdlMethod.

        Raises:
            com.sun.star.lang.NoSuchMethodException: ``NoSuchMethodException``
        """
        ...
    def getMethods(self, nMethodConcepts: int) -> 'typing.Tuple[XIdlMethod_e3740d05, ...]':
        """
        returns a sequence of methods of the introspected object.
        """
        ...
    def getProperties(self, nPropertyConcepts: int) -> 'typing.Tuple[Property_8f4e0a76, ...]':
        """
        returns a sequence of properties of the introspected object
        """
        ...
    def getProperty(self, aName: str, nPropertyConcepts: int) -> 'Property_8f4e0a76':
        """
        returns information about a property if a property with the demanded name exists and if it accords to one of the demanded PropertyConcepts.
        
        The information is provided as Property struct.

        Raises:
            com.sun.star.container.NoSuchElementException: ``NoSuchElementException``
        """
        ...
    def getSuppliedMethodConcepts(self) -> int:
        """
        returns information about which method concepts described in the MethodConcept constants group are supported by this XIntrospectionAccess implementation.
        
        The minimum supported concepts should be:
        """
        ...
    def getSuppliedPropertyConcepts(self) -> int:
        """
        returns information about which property concepts described in the PropertyConcept constants group are supported by this XIntrospectionAccess implementation.
        
        The minimum supported concepts should be:
        """
        ...
    def getSupportedListeners(self) -> 'typing.Tuple[object, ...]':
        """
        returns the listener types supported by the introspected object.
        
        If the introspected object has the methods addFooListener( XFooListener xFoo ) and removeFooListener( XFooListener xFoo ) the type of XFooListener will be one of the elements in the returned sequence.
        """
        ...
    def hasMethod(self, aName: str, nMethodConcepts: int) -> bool:
        """
        allows to ask if a method with the demanded name exists and if it accords to one of the demanded MethodConcept.
        """
        ...
    def hasProperty(self, aName: str, nPropertyConcepts: int) -> bool:
        """
        allows to ask if a property with the demanded name exists and if it accords to one of the demanded PropertyConcept.
        """
        ...
    def queryAdapter(self, aInterfaceType: object) -> 'XInterface_8f010a43':
        """
        creates an adapter that implements an interface with the specified type.
        
        To access properties, query for the XPropertySet interface. If the XPropertySet can be queried, the XFastPropertySet interface must be supported too.
        
        If the introspected object implements a name container, the introspection should return the com.sun.star.container.XNameAccess and com.sun.star.container.XNameContainer interfaces.
        
        If the introspected object implements an index container, the introspection should return the com.sun.star.container.XIndexAccess and com.sun.star.container.XIndexContainer interfaces.
        
        If the introspected object implements an enumeration container, the introspection should return the com.sun.star.container.XEnumerationAccess interface.
        
        If the introspected object implements the com.sun.star.reflection.XIdlArray interface, the introspection should return this.
        
        To implement inaccurate name access, at all objects, which implement the com.sun.star.container.XNameAccess or XPropertySet interface, the XExactName interface has to be supported.

        Raises:
            com.sun.star.beans.IllegalTypeException: ``IllegalTypeException``
        """
        ...


