"""create order table

Revision ID: 556ff2c83f9f
Revises: 94537a354aba
Create Date: 2022-11-17 18:20:22.941546

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '556ff2c83f9f'
down_revision = '94537a354aba'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('orders',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('order_date', sa.DateTime(), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_date', sa.DateTime(), nullable=True),
    sa.Column('status', sa.Enum('RECEIVED', 'CONFIRMED', 'TRANSIT', 'CLOSED', 'DELETED', name='orderstatus'), nullable=False),
    sa.Column('shipping_name', sa.String(length=30), nullable=False),
    sa.Column('shipping_zip_code', sa.String(length=4), nullable=False),
    sa.Column('shipping_city', sa.String(length=25), nullable=False),
    sa.Column('shipping_address', sa.String(length=25), nullable=False),
    sa.Column('invoice_name', sa.String(length=30), nullable=False),
    sa.Column('invoice_zip_code', sa.String(length=4), nullable=False),
    sa.Column('invoice_city', sa.String(length=25), nullable=False),
    sa.Column('invoice_address', sa.String(length=25), nullable=False),
    sa.Column('invoice_tax_number', sa.String(length=25), nullable=True),
    sa.Column('shipping_method', sa.Integer(), nullable=False),
    sa.Column('payment_method', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['payment_method'], ['payment_methods.id'], ),
    sa.ForeignKeyConstraint(['shipping_method'], ['shipping_methods.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('orders')
    # ### end Alembic commands ###
