"use strict";
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSyntheticsMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class CloudWatchSyntheticsMetrics {
    static _2XxSum(dimensions) {
        return {
            namespace: 'CloudWatchSynthetics',
            metricName: '2xx',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static _4XxSum(dimensions) {
        return {
            namespace: 'CloudWatchSynthetics',
            metricName: '4xx',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static _5XxSum(dimensions) {
        return {
            namespace: 'CloudWatchSynthetics',
            metricName: '5xx',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static durationMaximum(dimensions) {
        return {
            namespace: 'CloudWatchSynthetics',
            metricName: 'Duration',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static failedSum(dimensions) {
        return {
            namespace: 'CloudWatchSynthetics',
            metricName: 'Failed',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static failedRequestsSum(dimensions) {
        return {
            namespace: 'CloudWatchSynthetics',
            metricName: 'Failed requests',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static successPercentAverage(dimensions) {
        return {
            namespace: 'CloudWatchSynthetics',
            metricName: 'SuccessPercent',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
}
exports.CloudWatchSyntheticsMetrics = CloudWatchSyntheticsMetrics;
//# sourceMappingURL=data:application/json;base64,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