import { Construct } from 'constructs';
import { Duration } from '../duration';
import { Size } from '../size';
import { Construct as CoreConstruct } from '../construct-compat';
/**
 * (experimental) Initialization properties for `CustomResourceProvider`.
 *
 * @experimental
 */
export interface CustomResourceProviderProps {
    /**
     * (experimental) A local file system directory with the provider's code.
     *
     * The code will be
     * bundled into a zip asset and wired to the provider's AWS Lambda function.
     *
     * @experimental
     */
    readonly codeDirectory: string;
    /**
     * (experimental) The AWS Lambda runtime and version to use for the provider.
     *
     * @experimental
     */
    readonly runtime: CustomResourceProviderRuntime;
    /**
     * (experimental) A set of IAM policy statements to include in the inline policy of the provider's lambda function.
     *
     * @default - no additional inline policy
     * @experimental
     * @example
     *
     *   [{ Effect: 'Allow', Action: 's3:PutObject*', Resource: '*' }]
     */
    readonly policyStatements?: any[];
    /**
     * (experimental) AWS Lambda timeout for the provider.
     *
     * @default Duration.minutes(15)
     * @experimental
     */
    readonly timeout?: Duration;
    /**
     * (experimental) The amount of memory that your function has access to.
     *
     * Increasing the
     * function's memory also increases its CPU allocation.
     *
     * @default Size.mebibytes(128)
     * @experimental
     */
    readonly memorySize?: Size;
    /**
     * (experimental) Key-value pairs that are passed to Lambda as Environment.
     *
     * @default - No environment variables.
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) A description of the function.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
}
/**
 * (experimental) The lambda runtime to use for the resource provider.
 *
 * This also indicates
 * which language is used for the handler.
 *
 * @experimental
 */
export declare enum CustomResourceProviderRuntime {
    /**
     * (deprecated) Node.js 12.x.
     *
     * @deprecated Use {@link NODEJS_12_X}
     */
    NODEJS_12 = "nodejs12.x",
    /**
     * Node.js 12.x
     */
    NODEJS_12_X = "nodejs12.x",
    /**
     * (experimental) Node.js 14.x.
     *
     * @experimental
     */
    NODEJS_14_X = "nodejs14.x"
}
/**
 * (experimental) An AWS-Lambda backed custom resource provider.
 *
 * @experimental
 */
export declare class CustomResourceProvider extends CoreConstruct {
    /**
     * (experimental) Returns a stack-level singleton ARN (service token) for the custom resource provider.
     *
     * @param scope Construct scope.
     * @param uniqueid A globally unique id that will be used for the stack-level construct.
     * @param props Provider properties which will only be applied when the provider is first created.
     * @returns the service token of the custom resource provider, which should be
     * used when defining a `CustomResource`.
     * @experimental
     */
    static getOrCreate(scope: Construct, uniqueid: string, props: CustomResourceProviderProps): string;
    /**
     * (experimental) Returns a stack-level singleton for the custom resource provider.
     *
     * @param scope Construct scope.
     * @param uniqueid A globally unique id that will be used for the stack-level construct.
     * @param props Provider properties which will only be applied when the provider is first created.
     * @returns the service token of the custom resource provider, which should be
     * used when defining a `CustomResource`.
     * @experimental
     */
    static getOrCreateProvider(scope: Construct, uniqueid: string, props: CustomResourceProviderProps): CustomResourceProvider;
    /**
     * (experimental) The ARN of the provider's AWS Lambda function which should be used as the `serviceToken` when defining a custom resource.
     *
     * @experimental
     * @example
     *
     *   new CustomResource(this, 'MyCustomResource', {
     *     // ...
     *     serviceToken: myProvider.serviceToken, // <--- here
     *   })
     */
    readonly serviceToken: string;
    /**
     * (experimental) The ARN of the provider's AWS Lambda function role.
     *
     * @experimental
     */
    readonly roleArn: string;
    /**
     * @experimental
     */
    protected constructor(scope: Construct, id: string, props: CustomResourceProviderProps);
    private renderEnvironmentVariables;
}
