from enum import Enum


class EventType(Enum):
    T_EVENT_REGISTERED_USER = "T_EVENT_REGISTERED_USER"
    T_EVENT_GENERAL_ORDER_MADE = "T_EVENT_GENERAL_ORDER_MADE"
    T_EVENT_MOBILE_RECHARGE_ORDER_MADE = "T_EVENT_MOBILE_RECHARGE_ORDER_MADE"
    T_EVENT_PROFESSIONAL_INDICATED = "T_EVENT_PROFESSIONAL_INDICATED"
    T_EVENT_PROFESSIONAL_REGISTERED = "T_EVENT_PROFESSIONAL_REGISTERED"
    T_EVENT_FIRST_PURCHASE_RECEIPT_SUCCESS = "T_EVENT_FIRST_PURCHASE_RECEIPT_SUCCESS"
    T_EVENT_PURCHASE_RECEIPT_STATUS_NON_ELIGIBLE = "T_EVENT_PURCHASE_RECEIPT_STATUS_NON_ELIGIBLE"
    T_EVENT_USER_PASSWORD_CHANGE_REQUEST = "T_EVENT_USER_PASSWORD_CHANGE_REQUEST"
    T_EVENT_USER_PASSWORD_CHANGE_REQUEST_SMS = "T_EVENT_USER_PASSWORD_CHANGE_REQUEST_SMS"
    T_EVENT_USER_PASSWORD_CHANGE_REQUEST_EMAIL = "T_EVENT_USER_PASSWORD_CHANGE_REQUEST_EMAIL"
    T_EVENT_USER_PASSWORD_CHANGE_REQUEST_WHATSAPP = "T_EVENT_USER_PASSWORD_CHANGE_REQUEST_WHATSAPP"
    T_EVENT_USER_PASSWORD_CHANGE_CONFIRM = "T_EVENT_USER_PASSWORD_CHANGE_CONFIRM"
    T_EVENT_USER_SELLER_APP_ACCESS_LIBERATED = "T_EVENT_USER_SELLER_APP_ACCESS_LIBERATED"
    T_EVENT_REDEMPTION_CONFIRM = "T_EVENT_REDEMPTION_CONFIRM"
    T_EVENT_POINTS_DEVOLUTION = "T_EVENT_POINTS_DEVOLUTION"
    T_EVENT_MANAGER_REQUEST_TO_CONFIRM_REGISTER_EMPLOY = "T_EVENT_MANAGER_REQUEST_TO_CONFIRM_REGISTER_EMPLOY"
    T_EVENT_REQUEST_TO_CONFIRM_REGISTER_EMPLOYEE = "T_EVENT_REQUEST_TO_CONFIRM_REGISTER_EMPLOYEE"
    T_EVENT_PRE_REGISTER_EMPLOYEE = "T_EVENT_PRE_REGISTER_EMPLOYEE"
    T_EVENT_PRE_REGISTER_EMPLOYEE_DENIED = "T_EVENT_PRE_REGISTER_EMPLOYEE_DENIED"
    T_EVENT_PRE_REGISTER_EMPLOYEE_ACCEPTED = "T_EVENT_PRE_REGISTER_EMPLOYEE_ACCEPTED"
    T_EVENT_PROFESSIONAL_RULES_AGREEMENT_ACCEPTED = "T_EVENT_PROFESSIONAL_RULES_AGREEMENT_ACCEPTED"
    T_EVENT_INVITE_EMPLOYEE_TO_REGISTER = "T_EVENT_INVITE_EMPLOYEE_TO_REGISTER"
    T_EVENT_INVITE_OWNER_TO_REGISTER = "T_EVENT_INVITE_OWNER_TO_REGISTER"
    T_EVENT_SEND_EMAIL_VALIDATION_LINK = "T_EVENT_SEND_EMAIL_VALIDATION_LINK"
    T_EVENT_ONBOARDING_PHONE_TOKEN = "T_EVENT_ONBOARDING_PHONE_TOKEN"
    T_EVENT_UPDATE_PHONE_TOKEN = "T_EVENT_UPDATE_PHONE_TOKEN"
    T_EVENT_PURCHASE_RECEIPT_REPEATED = "T_EVENT_PURCHASE_RECEIPT_REPEATED"
    T_EVENT_PURCHASE_RECEIPT_EXPIRED = "T_EVENT_PURCHASE_RECEIPT_EXPIRED"
    T_EVENT_PURCHASE_RECEIPT_INCONSISTENCY = "T_EVENT_PURCHASE_RECEIPT_INCONSISTENCY"
    T_EVENT_PURCHASE_RECEIPT_PRODUCTS_NOT_ELIGIBLE = "T_EVENT_PURCHASE_RECEIPT_PRODUCTS_NOT_ELIGIBLE"
    T_EVENT_PURCHASE_RECEIPT_VALID = "T_EVENT_PURCHASE_RECEIPT_VALID"
    T_EVENT_PURCHASE_RECEIPT_NF_MAXVALUE = "T_EVENT_PURCHASE_RECEIPT_NF_MAXVALUE"
    T_EVENT_PURCHASE_RECEIPT_MAXVALUE = "T_EVENT_PURCHASE_RECEIPT_MAXVALUE"
    T_EVENT_USER_POINTS_EXPIRED = "T_EVENT_USER_POINTS_EXPIRED"
    T_EVENT_MMN_PROFESSIONAL_INDICATED_BY_EMPLOYEE = "T_EVENT_MMN_PROFESSIONAL_INDICATED_BY_EMPLOYEE"
    T_EVENT_MMN_PROFESSIONAL_SENT_RECEIPT = "T_EVENT_MMN_PROFESSIONAL_SENT_RECEIPT"
    T_EVENT_MMN_PROFESSIONAL_FIRST_ORDER = "T_EVENT_MMN_PROFESSIONAL_FIRST_ORDER"
    T_EVENT_OWNER_POINTS_TRANSFER = "T_EVENT_OWNER_POINTS_TRANSFER"
    T_EVENT_RECEIVER_POINTS_TRANSFER = "T_EVENT_RECEIVER_POINTS_TRANSFER"
    T_EVENT_BALC_ACCEPTED_INDICATION = "T_EVENT_BALC_ACCEPTED_INDICATION"
    T_EVENT_NON_TAX_CUPON_LIMIT = "T_EVENT_NON_TAX_CUPON_LIMIT"
    T_EVENT_RECEIPT_WRITTEN_IN_PEN = "T_EVENT_RECEIPT_WRITTEN_IN_PEN"
    T_EVENT_FRAUD_SUSPECT = "T_EVENT_FRAUD_SUSPECT"
    T_EVENT_TOP_NEW_USER = "T_EVENT_TOP_NEW_USER"
    T_STAMP_NEW_PROFISSIONAL_MAIS = "T_STAMP_NEW_PROFISSIONAL_MAIS"
    T_ONE_LAST_STAMP_NEW_PROFISSIONAL_MAIS = "T_ONE_LAST_STAMP_NEW_PROFISSIONAL_MAIS"
    T_COMPLETE_CARD_NEW_PROFISSIONAL_MAIS = "T_COMPLETE_CARD_NEW_PROFISSIONAL_MAIS"
    T_LAST_30_DAYS_OF_BONUS_NEW_PROFISSIONAL_MAIS = "T_LAST_30_DAYS_OF_BONUS_NEW_PROFISSIONAL_MAIS"

    @classmethod
    def get_choices(cls):
        return tuple(item.value for item in cls)
