# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing
from ..beans.property import Property as Property_8f4e0a76


class PropertyCommandArgument(object):
    """
    Struct Class

    The argument for the \"addProperty\" command.
    
    **since**
    
        Apache OpenOffice 4.0, LibreOffice 4.2

    See Also:
        `API PropertyCommandArgument <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1PropertyCommandArgument.html>`_
    """
    typeName: Literal['com.sun.star.ucb.PropertyCommandArgument']

    def __init__(self, Property: typing.Optional[Property_8f4e0a76] = ..., DefaultValue: typing.Optional[object] = ...) -> None:
        """
        Constructor

        Arguments:
            Property (Property, optional): Property value.
            DefaultValue (object, optional): DefaultValue value.
        """


    @property
    def Property(self) -> Property_8f4e0a76:
        """
        The property that the command has to add.
        """


    @property
    def DefaultValue(self) -> object:
        """
        The default value of the property.
        """


