# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.document
import typing
from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa
if typing.TYPE_CHECKING:
    from ..i18n.x_forbidden_characters import XForbiddenCharacters as XForbiddenCharacters_df60e2d

class Settings(XPropertySet_bc180bfa):
    """
    Service Class

    describes properties that apply to the whole document of any application.
    
    For application specific settings, please refer to the individual services.
    
    **since**
    
        LibreOffice 6.2

    See Also:
        `API Settings <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1document_1_1Settings.html>`_
    """
    @property
    def PrinterSetup(self) -> 'typing.Tuple[int, ...]':
        """
        platform and driver dependent printer setup data.
        
        This property serves to capture the current printer setup settings, such as paper tray, printer options, etc. The data can typically be interpreted only by the system that generated it. The PrinterSetup property may be used to save and restore the user's printer settings.
        """
    @property
    def AddExternalLeading(self) -> bool:
        """
        layout engine should add value of a Font's \"external leading\" attribute to the line spacing.
        """
    @property
    def ApplyUserData(self) -> bool:
        """
        specifies if the user-specific settings saved within a document should be loaded with the document.
        """
    @property
    def AutoCalculate(self) -> bool:
        """
        """
    @property
    def BitmapTableURL(self) -> str:
        """
        """
    @property
    def CharacterCompressionType(self) -> int:
        """
        specifies the compression (character spacing) type used for Asian characters.
        """
    @property
    def ColorTableURL(self) -> str:
        """
        contains the URL that points to a color table (file extension .soc) that will be used for showing a palette in dialogs using colors.
        """
    @property
    def CurrentDatabaseCommand(self) -> str:
        """
        a string value, specifying the name of the object displayed currently (or the SQL statement used).
        """
    @property
    def CurrentDatabaseCommandType(self) -> int:
        """
        determines the interpretation of the property DataTableName.
        """
    @property
    def CurrentDatabaseDataSource(self) -> str:
        """
        The name of the globally registered com.sun.star.sdb.DataSource from which the current data is taken.
        
        The data source can e.g. be used for feeding a form letter.
        """
    @property
    def DashTableURL(self) -> str:
        """
        """
    @property
    def DefaultTabStop(self) -> int:
        """
        """
    @property
    def EmbedAsianScriptFonts(self) -> bool:
        """
        Whether to embed Asian script fonts.
        
        **since**
        
            LibreOffice 6.2
        """
    @property
    def EmbedComplexScriptFonts(self) -> bool:
        """
        Whether to embed Complex script fonts.
        
        **since**
        
            LibreOffice 6.2
        """
    @property
    def EmbedFonts(self) -> bool:
        """
        Whether to embed fonts used by the document (see e.g.
        
        handling of OOXML embedRegular etc.)
        
        **since**
        
            LibreOffice 4.0
        """
    @property
    def EmbedLatinScriptFonts(self) -> bool:
        """
        Whether to embed Latin script fonts.
        
        **since**
        
            LibreOffice 6.2
        """
    @property
    def EmbedOnlyUsedFonts(self) -> bool:
        """
        Whether to embed only the fonts that are used in the document.
        
        **since**
        
            LibreOffice 6.2
        """
    @property
    def EmbedSystemFonts(self) -> bool:
        """
        Whether to embed also system fonts used by the document.
        
        Does not have any effect if EmbedFonts is false.
        
        **since**
        
            LibreOffice 4.0
        """
    @property
    def FieldAutoUpdate(self) -> bool:
        """
        specifies if fields in text documents are updated automatically.
        """
    @property
    def ForbiddenCharacters(self) -> 'XForbiddenCharacters_df60e2d':
        """
        gives access to the set of forbidden characters.
        """
    @property
    def GradientTableURL(self) -> str:
        """
        """
    @property
    def HatchTableURL(self) -> str:
        """
        """
    @property
    def IsKernAsianPunctuation(self) -> bool:
        """
        specifies if kerning is applied to Asian punctuation.
        
        Applies only if kerning is enabled.
        """
    @property
    def IsPrintBooklet(self) -> bool:
        """
        determines if the document will be printed as a booklet (brochure), i.e., two document pages are put together on one physical page, such that you can fold the print result and get a booklet.
        
        Note, that you have to print in duplex mode, if both, IsPrintBookletFront and IsPrintBookletBack are set to TRUE.
        """
    @property
    def IsPrintBookletBack(self) -> bool:
        """
        is only effective, if IsPrintBooklet is TRUE.
        
        If this property is also TRUE, only the backs of the pages of your booklet are printed.
        
        This is especially useful, if your printer does not supply duplex printing.
        """
    @property
    def IsPrintBookletFront(self) -> bool:
        """
        is only effective, if IsPrintBooklet is TRUE.
        
        If this property is also TRUE, only the fronts of the pages of your booklet are printed.
        
        This is especially useful, if your printer does not supply duplex printing.
        """
    @property
    def LineEndTableURL(self) -> str:
        """
        """
    @property
    def LinkUpdateMode(self) -> int:
        """
        specifies the update mode for links when loading text documents.
        
        For supported values see the constants group LinkUpdateModes.
        """
    @property
    def PrintQuality(self) -> int:
        """
        how printing uses color.
        """
    @property
    def PrinterIndependentLayout(self) -> int:
        """
        forbid use of printer metrics for layout
        
        For supported values see the constants group PrinterIndependentLayout.
        """
    @property
    def PrinterName(self) -> str:
        """
        printer used by the document.
        """
    @property
    def SaveVersionOnClose(self) -> bool:
        """
        specifies if a new version is created if a document has been modified and you want to close it.
        """
    @property
    def UpdateFromTemplate(self) -> bool:
        """
        specifies if the document should be updated when the template it was created from changes.
        
        Applies only for documents that were created from a template.
        """


