# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt.grid
# Libre Office Version: 7.3
from typing_extensions import Literal
from ...lang.event_object import EventObject as EventObject_a3d70b03
from ...uno.x_interface import XInterface as XInterface_8f010a43
import typing


class GridDataEvent(EventObject_a3d70b03):
    """
    Struct Class

    used to notify changes in the data represented by an XMutableGridDataModel.
    
    Effectively, a GridDataEvent denotes a continuous two-dimensional cell range within a grid's data model, which is affected by a certain change.
    
    **since**
    
        OOo 3.3

    See Also:
        `API GridDataEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1grid_1_1GridDataEvent.html>`_
    """
    typeName: Literal['com.sun.star.awt.grid.GridDataEvent']

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = ..., FirstColumn: typing.Optional[int] = ..., LastColumn: typing.Optional[int] = ..., FirstRow: typing.Optional[int] = ..., LastRow: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            FirstColumn (int, optional): FirstColumn value.
            LastColumn (int, optional): LastColumn value.
            FirstRow (int, optional): FirstRow value.
            LastRow (int, optional): LastRow value.
        """


    @property
    def FirstColumn(self) -> int:
        """
        denotes the first column affected by a change.
        
        If FirstColumn is -1, the listener should assume that all rows of a grid's data model are affected.
        """


    @property
    def LastColumn(self) -> int:
        """
        denotes the last column affected by a change
        """


    @property
    def FirstRow(self) -> int:
        """
        denotes the first row affected by a change.
        
        If FirstRow is -1, the listener should assume that all rows of a grid's data model are affected.
        """


    @property
    def LastRow(self) -> int:
        """
        denotes the last row affected by a change
        """


