# mypy-boto3-route53

[![PyPI - mypy-boto3-route53](https://img.shields.io/pypi/v/mypy-boto3-route53.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-route53.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Route53 1.14.17](https://boto3.amazonaws.com/v1/documentation/api/1.14.17/reference/services/route53.html#Route53) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Route53` service.

```bash
python -m pip install boto3-stubs[route53]
```

## How to use

### Client annotations

`Route53Client` provides annotations for `boto3.client("route53")`.

```python
import boto3

from mypy_boto3_route53 import Route53Client
from mypy_boto3_route53.paginator import (
    ListHealthChecksPaginator,
    ListHostedZonesPaginator,
    ListQueryLoggingConfigsPaginator,
    ListResourceRecordSetsPaginator,
    ListVPCAssociationAuthorizationsPaginator,
)
from mypy_boto3_route53.type_defs import AccountLimitTypeDef, ...
from mypy_boto3_route53.waiter import ResourceRecordSetsChangedWaiter

client: Route53Client = boto3.client("route53")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: Route53Client = session.client("route53")
```

### Paginators annotations

`mypy_boto3_route53.paginator` module contains type annotations for all paginators.

```python

client: Route53Client = boto3.client("route53")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_health_checks_paginator: ListHealthChecksPaginator = client.get_paginator("list_health_checks")
list_hosted_zones_paginator: ListHostedZonesPaginator = client.get_paginator("list_hosted_zones")
list_query_logging_configs_paginator: ListQueryLoggingConfigsPaginator = client.get_paginator("list_query_logging_configs")
list_resource_record_sets_paginator: ListResourceRecordSetsPaginator = client.get_paginator("list_resource_record_sets")
list_vpc_association_authorizations_paginator: ListVPCAssociationAuthorizationsPaginator = client.get_paginator("list_vpc_association_authorizations")
```


### Waiters annotations

`mypy_boto3_route53.waiter` module contains type annotations for all waiters.

```python

client: Route53Client = boto3.client("route53")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
resource_record_sets_changed_waiter: ResourceRecordSetsChangedWaiter = client.get_waiter("resource_record_sets_changed")
```





### Typed dictionations

`mypy_boto3_route53.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AccountLimitTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_route53` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("route53")

session_client = boto3.Session().client("route53")
```
