from typing import List

from pydantic.main import BaseModel

from aidkit_client._endpoints.constants import Constants
from aidkit_client._endpoints.models import FilterResponse, RequiredContextDescription
from aidkit_client.aidkit_api import HTTPService
from aidkit_client.exceptions import ResourceWithIdNotFoundError


# this is not autogenerated, so we do not have to include the whole
# spec including all the Registrables
class PipelineResponse(BaseModel):
    id: int
    name: str
    context: List[RequiredContextDescription]


class ListPipelineResponse(BaseModel):
    filter: FilterResponse
    items: List[PipelineResponse]


class PipelinesAPI:
    api: HTTPService

    def __init__(self, api: HTTPService):
        self.api = api

    async def get_by_id(self, pipeline_id: int) -> PipelineResponse:
        result = await self.api.get(
            path=f"{Constants.PIPELINES_PATH}/{pipeline_id}",
            parameters=None,
        )
        if result.is_not_found:
            raise ResourceWithIdNotFoundError(f"Pipeline with ID: {pipeline_id} not found")
        return PipelineResponse(
            **result.body_dict_or_error(f"Error fetching Pipeline with ID {pipeline_id}.")
        )

    async def get_all(self) -> List[PipelineResponse]:
        result = await self.api.get(path=Constants.PIPELINES_PATH, parameters=None)
        return ListPipelineResponse(
            **result.body_dict_or_error("Error fetching pipeline list.")
        ).items

    async def delete(self, pipeline_id: int) -> None:
        await self.api.delete(path=f"{Constants.PIPELINES_PATH}/{pipeline_id}")
