# generated by datamodel-codegen:
#   filename:  <stdin>

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field
from typing_extensions import Literal


class MLModelVersionResponse(BaseModel):
    """
    MLModel version response model.
    """

    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    pipeline_run_ids: List[int] = Field(..., title="Pipeline Run Ids")
    created_at: Optional[str] = Field(None, title="Created At")


class PaginationResponse(BaseModel):
    total_number_of_items: int = Field(..., ge=0.0, title="Total Number Of Items")
    total_number_of_pages: int = Field(..., ge=0.0, title="Total Number Of Pages")
    offset: int = Field(..., ge=0.0, title="Offset")
    limit: int = Field(..., ge=0.0, title="Limit")


class FilterResponse(BaseModel):
    pagination: PaginationResponse


class ListMLModelVersionResponse(BaseModel):
    """
    List MLModel version response model.
    """

    filter: FilterResponse
    items: List[MLModelVersionResponse] = Field(..., title="Items")


class BatchDim(Enum):
    """
    Location of batch dimension, if it exists.
    """

    First = "First"
    Last = "Last"
    No_Batch = "No Batch"


class SpecificLengthDimensionModel(BaseModel):
    """
    Output dimension length has to be specified.
    """

    axis: int = Field(..., title="Axis")
    length: int = Field(..., description="Length of dimension.", gt=0.0, title="Length")


class GrayScaleChannelDimensionModel(BaseModel):
    """
    Gray scale channel dimension must be of length 1.
    """

    axis: int = Field(..., title="Axis")
    length: Literal[1] = Field(1, title="Length")


class UnspecifiedLengthDimensionModel(BaseModel):
    """
    Output dimension can be of any length.
    """

    axis: int = Field(..., title="Axis")
    length: Literal["*"] = Field("*", title="Length")


class GrayScaleImageInputDimensionsModel(BaseModel):
    """
    Gray Scale Image input has optional batch dimension.
    """

    height: SpecificLengthDimensionModel = Field(
        ..., description="Height axis index and length", title="Height"
    )
    width: SpecificLengthDimensionModel = Field(
        ..., description="Width axis index and length", title="Width"
    )
    channel: GrayScaleChannelDimensionModel = Field(
        ..., description="Channel axis index", title="Channel"
    )
    batch: Optional[UnspecifiedLengthDimensionModel] = Field(
        None, description="Batch axis and length", title="Batch"
    )


class ZeroToOneScaler(BaseModel):
    """
    Normalize data to [0, 1] range.
    """

    name: Literal["ZeroToOne"] = Field("ZeroToOne", title="Scaler [0, 1]")


class MinusOneToOneScaler(BaseModel):
    """
    Normalize data to [-1, 1] range.
    """

    name: Literal["MinusOneToOne"] = Field("MinusOneToOne", title="Scaler [-1, 1]")


class GrayscaleCustomScaler(BaseModel):
    """
    Scale the data with the given mean and standard deviation.
    """

    name: Literal["GrayScaleCustom"] = Field("GrayScaleCustom", title="Custom")
    data_mean: float = Field(0.0, title="Mean")
    data_std: float = Field(1.0, gt=0.0, title="Standard Deviation")


class GrayScaleImageInputSpecs(BaseModel):
    """
    A grayscale image has 1 channel.
    """

    name: Literal["GrayScaleImage"] = Field("GrayScaleImage", title="Image (Grayscale)")
    batch_dim: BatchDim = Field("No Batch", title="Batch Axis Location")
    dimensions: GrayScaleImageInputDimensionsModel
    image_scaler: Union[ZeroToOneScaler, MinusOneToOneScaler, GrayscaleCustomScaler] = Field(
        {"name": "ZeroToOne", "_model_version_hash": "bZj687kPju5uLQ=="},
        description=(
            "Can choose pre-processing function that normalizes data to a range and standardizes"
            " data to given mean and standard deviation."
        ),
        title="Image Scaler",
    )


class ColorChannelDimensionModel(BaseModel):
    """
    Color channel dimension must be of length 3.
    """

    axis: int = Field(..., title="Axis")
    length: Literal[3] = Field(3, title="Length")


class ColorImageInputDimensionsModel(BaseModel):
    """
    Color Image input has optional batch dimension.
    """

    height: SpecificLengthDimensionModel = Field(
        ..., description="Height axis index and length", title="Height"
    )
    width: SpecificLengthDimensionModel = Field(
        ..., description="Width axis index and length", title="Width"
    )
    channel: ColorChannelDimensionModel = Field(
        ..., description="Channel axis index", title="Channel"
    )
    batch: Optional[UnspecifiedLengthDimensionModel] = Field(
        None, description="Batch axis and length", title="Batch"
    )


class DataStdItem(BaseModel):
    __root__: float = Field(..., gt=0.0)


class ImageNetPresetScaler(BaseModel):
    """
    Scale data with ImageNet preset mean and standard deviation values.
    """

    name: Literal["ImageNetScaler"] = Field("ImageNetScaler", title="ImageNet Preset Scaler")
    data_mean: List[float] = Field([0.485, 0.456, 0.406], max_items=3, min_items=3, title="Mean")
    data_std: List[DataStdItem] = Field(
        [0.229, 0.224, 0.225], max_items=3, min_items=3, title="Standard Deviation"
    )


class DataStdItem1(BaseModel):
    __root__: float = Field(..., gt=0.0)


class RGBCustomScaler(BaseModel):
    """
    Scale the data with the given per-channel mean and standard deviation
    values.
    """

    name: Literal["RGBCustom"] = Field("RGBCustom", title="Custom")
    data_mean: List[float] = Field([0.0, 0.0, 0.0], max_items=3, min_items=3, title="Mean")
    data_std: List[DataStdItem1] = Field(
        [1.0, 1.0, 1.0], max_items=3, min_items=3, title="Standard Deviation"
    )


class ColorImageInputSpecs(BaseModel):
    """
    A color image has 3 channels.
    """

    name: Literal["ColorImage"] = Field("ColorImage", title="Image (Color)")
    batch_dim: BatchDim = Field("No Batch", title="Batch Axis Location")
    dimensions: ColorImageInputDimensionsModel
    image_scaler: Union[
        ZeroToOneScaler, MinusOneToOneScaler, ImageNetPresetScaler, RGBCustomScaler
    ] = Field(
        {"name": "ZeroToOne", "_model_version_hash": "bZj687kPju5uLQ=="},
        description=(
            "Can choose pre-processing function that normalizes data to a range and standardizes"
            " data to given mean and standard deviation."
        ),
        title="Image Scaler",
    )


class AutogeneratedClasses(BaseModel):
    """
    The class names are auto-generated, e.g., class_01, class_02, ..., class_10
    for a total of 10 classes.
    """

    num_classes: int = Field(
        ..., description="Specify the total number of classes. ", gt=0.0, title="Number of Classes "
    )


class DictOutputFormat(BaseModel):
    """
    Model outputs a dictionary of tensors.
    """

    name: Literal["Dict"] = Field("Dict", title="Dictionary of Tensors")
    output_target: str = Field(..., title="Output Target")


class SingleOutputFormat(BaseModel):
    """
    Model outputs a single tensor.
    """

    name: Literal["Single"] = Field("Single", title="Single Tensor")


class ClassificationScoreDimensionsModel(BaseModel):
    """
    Classification Output has class dimension.
    """

    class_: Optional[UnspecifiedLengthDimensionModel] = Field(None, title="Class")
    batch: Optional[UnspecifiedLengthDimensionModel] = Field(None, title="Batch")


class ClassificationModelOutputSpecs(BaseModel):
    """
    Model returns a classification, i.e., a tensor of either logit or softmax
    scores for all classes.
    """

    class_names: Union[List[str], AutogeneratedClasses] = Field(
        ..., description="List of class names or number of classes", title="Class Names"
    )
    output_format: Union[DictOutputFormat, SingleOutputFormat] = Field(..., title="Output Format")
    dimensions: Optional[ClassificationScoreDimensionsModel] = Field(
        None, title="Classification Score Dimensions"
    )
    name: Literal["ClassificationOutput"] = Field("ClassificationOutput", title="Classification")


class SegmentationScoreDimensionsModel(BaseModel):
    """
    Segmentation Output has width, height, and class dimensions.
    """

    height: UnspecifiedLengthDimensionModel = Field(..., title="Height")
    width: UnspecifiedLengthDimensionModel = Field(..., title="Width")
    class_: UnspecifiedLengthDimensionModel = Field(..., title="Class")
    batch: Optional[UnspecifiedLengthDimensionModel] = Field(None, title="Batch")


class SegmentationModelOutputSpecs(BaseModel):
    """
    Model returns a segmentation map, i.e., a tensor of either logit or softmax
    scores for all classes for each pixel.
    """

    class_names: Union[List[str], AutogeneratedClasses] = Field(
        ..., description="List of class names or number of classes", title="Class Names"
    )
    output_format: Union[DictOutputFormat, SingleOutputFormat] = Field(..., title="Output Format")
    dimensions: Optional[SegmentationScoreDimensionsModel] = Field(
        None, title="Segmentation Score Dimensions"
    )
    name: Literal["SegmentationOutput"] = Field("SegmentationOutput", title="Segmentation")


class DetectionScoreDimensionsTypes(Enum):
    """
    Enum for detection score dimension order types.
    """

    boxes_x_classes = "boxes_x_classes"
    classes_x_boxes = "classes_x_boxes"


class BoundingBoxDimensionsTypes(Enum):
    """
    Enum for bounding box dimension order types.
    """

    boxes_x_coordinates = "boxes_x_coordinates"
    coordinates_x_boxes = "coordinates_x_boxes"


class DetectionDictOutputFormat(BaseModel):
    """
    Model outputs a dictionary of tensors.
    """

    name: Literal["DetectionDict"] = Field("DetectionDict", title="Dictionary of Tensors")
    scores_key: str = Field(
        ...,
        description=(
            "Key pointing to the differentiable output layer in shape (batch size x bounding boxes"
            " x classes) just before the NMS."
        ),
        title="Scores Key",
    )
    score_dimension_type: DetectionScoreDimensionsTypes
    boxes_key: str = Field(
        ..., description="Key pointing to bounding box output.", title="Bounding Boxes Key"
    )
    box_dimension_type: BoundingBoxDimensionsTypes


class SequenceOutputFormat(BaseModel):
    """
    Model outputs a sequence of tensors.
    """

    name: Literal["Sequence"] = Field("Sequence", title="Sequence of Tensors")
    scores_key: int = Field(
        ...,
        description=(
            "Index reference to the differentiable output layer in shape (batch size x bounding"
            " boxes x classes) just before the NMS."
        ),
        ge=0.0,
        title="Scores Index",
    )
    score_dimension_type: DetectionScoreDimensionsTypes
    boxes_key: int = Field(
        ..., description="Index to bounding box output", ge=0.0, title="Bounding Boxes Index"
    )
    box_dimension_type: BoundingBoxDimensionsTypes


class DetectionScoreDimensionsModel(BaseModel):
    """
    DetectionScore Output.
    """

    proposal: UnspecifiedLengthDimensionModel = Field(..., title="Object proposal")
    class_: UnspecifiedLengthDimensionModel = Field(..., title="Class")
    batch: Optional[UnspecifiedLengthDimensionModel] = Field(None, title="Batch")


class BoundingBoxFormatType(Enum):
    """
    Bounding box coordinate format.
    """

    xyxy = "xyxy"
    yxyx = "yxyx"
    xywh = "xywh"
    ccwh = "ccwh"


class NMSPostProcessor(BaseModel):
    """
    Apply non-max suppression to object proposals.
    """

    iou_threshold: float = Field(
        0.5,
        description="Overlapping boxes with IOU greater than this threshold will be discarded.",
        ge=0.0,
        le=1.0,
        title="IOU Threshold",
    )
    score_threshold: float = Field(
        0,
        description="Boxes with confidence below this threshold will be discarded.",
        title="Score Threshold",
    )
    class_to_suppress: Optional[int] = Field(
        None,
        description=(
            "A single class index. Boxes which are classified as this class are removed before"
            " non-max suppression. A typical choice is to select the index that refers to a"
            " 'background' class."
        ),
        title="Class to Suppress",
    )


class BoundingBoxDimensionsModel(BaseModel):
    """
    Bounding Box Output.
    """

    proposal: UnspecifiedLengthDimensionModel = Field(..., title="Object proposal")
    coordinate: UnspecifiedLengthDimensionModel = Field(..., title="Coordinate")
    batch: Optional[UnspecifiedLengthDimensionModel] = Field(None, title="Batch")


class DetectionModelOutputSpecs(BaseModel):
    """
    Output specification for models that return detections scores.
    """

    class_names: Union[List[str], AutogeneratedClasses] = Field(
        ..., description="List of class names or number of classes", title="Class Names"
    )
    output_format: Union[DetectionDictOutputFormat, SequenceOutputFormat] = Field(
        ..., title="Output Format"
    )
    dimensions: Optional[DetectionScoreDimensionsModel] = Field(None, title="Dimensions")
    name: Literal["DetectionOutput"] = Field("DetectionOutput", title="Detection")
    coordinate_format: BoundingBoxFormatType = Field(
        ..., description="Format of bounding box coordinates."
    )
    post_processor: NMSPostProcessor = Field(
        ...,
        description="Apply NMS postprocessing to model output.",
        title="Post Processor: Non-Max Suppression",
    )
    box_dimensions: Optional[BoundingBoxDimensionsModel] = Field(None, title="Box Dimensions")


class ImageModelContextSpecs(BaseModel):
    """
    Model for image input types.
    """

    name: Literal["ImageModelContext"] = Field("ImageModelContext", title="Computer Vision")
    input_specification: Union[GrayScaleImageInputSpecs, ColorImageInputSpecs] = Field(
        ..., title="Data Type"
    )
    output_specification: Union[
        ClassificationModelOutputSpecs, SegmentationModelOutputSpecs, DetectionModelOutputSpecs
    ] = Field(..., title="Task")


class TextInputDimensionsModel(BaseModel):
    """
    Text input has a string dimension and an optional batch dimension.
    """

    batch: Optional[UnspecifiedLengthDimensionModel] = Field(
        None, description="Batch axis and length", title="Batch"
    )


class NoPreTokenizerSpecs(BaseModel):
    """
    Do not apply pre-tokenization.
    """

    name: Literal["NoPreTokenizer"] = Field("NoPreTokenizer", title="No Pre-Tokenizer")


class SplitPreTokenizerSpecs(BaseModel):
    """
    Split text input before tokenization.
    """

    name: Literal["SplitPreTokenizer"] = Field("SplitPreTokenizer", title="Split")
    convert_to_lower_case: bool = Field(
        True,
        description=(
            "Whether to convert the text input to lower case. If True, 'This is A sentence' ->"
            " 'this is a sentence'. If False, 'This is A Sentence' -> 'This is A sentence'. "
        ),
        title="Convert to Lower Case",
    )
    whitespace: bool = Field(
        True,
        description=(
            "Whether to separate the input text into words. If True, 'this is a sentence' ->"
            " 'this', 'is', 'a', 'sentence'. If False, 'this is a sentence' -> 'this is a"
            " sentence'. "
        ),
        title="Split by Whitespace",
    )
    keep_punctuation: bool = Field(
        True,
        description=(
            "Whether to keep punctuation (.,;:!?()) as separate tokens. If True, 'hello! this is a"
            " sentence.' -> 'hello', '!', 'this', 'is', 'a', 'sentence', '.'If False, 'hello! this"
            " is a sentence.' -> 'hello', 'this', 'is', 'a', 'sentence'"
        ),
        title="Keep Punctuation",
    )


class ByteLevelPreTokenizerSpecs(BaseModel):
    """
    Encoding that maps each byte value to a unique symbol.
    """

    name: Literal["ByteLevelPreTokenizer"] = Field("ByteLevelPreTokenizer", title="Byte Level")


class NoTokenizerSpecs(BaseModel):
    """
    Do not apply tokenization.
    """

    name: Literal["NoTokenizer"] = Field("NoTokenizer", title="No Tokenizer")


class WordLevelTokenizerSpecs(BaseModel):
    """
    A word-level tokenizer maps each token to an ID according to a vocabulary.
    """

    name: Literal["WordLevelTokenizer"] = Field("WordLevelTokenizer", title="Word Level")
    unk_token: str = Field(
        "[UNK]",
        description="Symbol to represent tokens that are not in the vocabulary.",
        title="Unknown Token",
    )
    vocab: str = Field(
        ...,
        description=(
            "The expected format is a JSON representation of a dictionary where the keys are the"
            " symbols in the vocabulary (strings) and the values are the corresponding IDs"
            ' (integers), e.g.: {"hello": 1, "world": 2, "[UNK]": 3}'
        ),
        title="Vocabulary",
    )


class BPETokenizerSpecs(BaseModel):
    """
    Byte-Pair Encoding (BPE) creates a 'merge list' and an according vocabulary
    by iteratively creating entries from merging the most frequent symbol
    pairs.

    During tokenization, tokens are first merged according to the 'merge
    list' and then mapped to IDs using the vocabulary.
    """

    name: Literal["BPETokenizer"] = Field("BPETokenizer", title="BPE Tokenizer")
    unk_token: str = Field(
        "<unk>",
        description="Symbol to represent tokens that are not in the vocabulary.",
        title="Unknown Token",
    )
    vocab: str = Field(
        ...,
        description=(
            "The expected format is a JSON representation of a dictionary where the keys are the"
            " symbols in the vocabulary (strings) and the values are the corresponding IDs"
            ' (integers), e.g.: {"hello": 1, "world": 2, "[UNK]": 3}'
        ),
        title="Vocabulary",
    )
    merges: str = Field(
        ...,
        description=(
            "Symbol pairs to be merged during Byte-Pair Encoding. The expected format is a text"
            " where each line contains one pair of symbols, i.e.:\na b\nc d\ne f\n"
        ),
        title="Merges",
    )


class TextInputSpecs(BaseModel):
    """
    A string input.
    """

    name: Literal["Text"] = Field("Text", title="Text")
    batch_dim: BatchDim = Field("No Batch", title="Batch Axis Location")
    dimensions: Optional[TextInputDimensionsModel] = None
    pre_tokenizer: Union[
        NoPreTokenizerSpecs, SplitPreTokenizerSpecs, ByteLevelPreTokenizerSpecs
    ] = Field(..., title="Pre-Tokenizer")
    tokenizer: Union[NoTokenizerSpecs, WordLevelTokenizerSpecs, BPETokenizerSpecs] = Field(
        ..., title="Tokenizer"
    )


class TextModelContextSpecs(BaseModel):
    """
    Model for text input types.
    """

    name: Literal["TextModelContext"] = Field(
        "TextModelContext", title="Natural Language Processing"
    )
    input_specification: TextInputSpecs = Field(..., title="Data Type")
    output_specification: ClassificationModelOutputSpecs = Field(..., title="Task")


class FrameworkType(Enum):
    """
    Identification of the type of deep learning framework.

    Required for parsing model binaries with the correct libraries.
    """

    TENSORFLOW = "TENSORFLOW"
    PYTORCH = "PYTORCH"


class MLModelCreationRequestForSchema(BaseModel):
    model: bytes = Field(..., title="Model")
    name: str = Field(..., title="Name")
    version_name: str = Field(..., title="Version Name")
    context: Union[ImageModelContextSpecs, TextModelContextSpecs] = Field(..., title="Domain")
    framework: FrameworkType


class MLModelResponse(BaseModel):
    """
    MLModel response model.
    """

    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    framework: FrameworkType
    context: Union[ImageModelContextSpecs, TextModelContextSpecs] = Field(..., title="Context")
    latest_version: Optional[MLModelVersionResponse] = None


class ListMLModelResponse(BaseModel):
    """
    List MLModel response model.
    """

    filter: FilterResponse
    items: List[MLModelResponse] = Field(..., title="Items")


class TargetClassInput(BaseModel):
    """
    Union of str/int used as an input.
    """

    name: Literal["TargetClassInput"] = Field(
        "TargetClassInput",
        description=(
            "Specifies the target class used by an algorithm either by `index` (an integer value"
            " starting with 0) or by taking the argmax of the model prediction."
        ),
        title="Target Class",
    )
    value: Union[int, Literal["argmax"]] = Field(..., title="Value")


class IdentifierInput(BaseModel):
    """
    An entity identifier.
    """

    name: Literal["IdentifierInput"] = Field(
        "IdentifierInput",
        description='Identifier (ID) for a resource such as "Dataset" and "Pipeline".',
        title="Resource ID",
    )
    value: int = Field(..., title="Value")


class UserProvidedContext(BaseModel):
    pipeline_node_id: int = Field(..., title="Pipeline Node Id")
    context_name: str = Field(..., title="Context Name")
    value: Union[TargetClassInput, IdentifierInput] = Field(..., title="Value")


class CreatePipelineRunRequest(BaseModel):
    pipeline_id: int = Field(..., title="Pipeline Id")
    context: List[UserProvidedContext] = Field(..., title="Context")


class PipelineRunState(Enum):
    """
    Life cycle of a pipeline run node.
    """

    PENDING = "PENDING"
    STOPPED = "STOPPED"
    RUNNING = "RUNNING"
    SUCCESS = "SUCCESS"
    FAILED = "FAILED"
    SAVING = "SAVING"


class PipelineRunNodeBatchResponse(BaseModel):
    id: int = Field(..., title="Id")
    state: PipelineRunState
    start_time: Optional[str] = Field(None, title="Start Time")
    finish_time: Optional[str] = Field(None, title="Finish Time")


class NamedEntity(BaseModel):
    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")


class PipelineRunResponse(BaseModel):
    id: int = Field(..., title="Id")
    nodes: List[PipelineRunNodeBatchResponse] = Field(..., title="Nodes")
    ml_model: Optional[NamedEntity] = None
    ml_model_version: Optional[NamedEntity] = None
    dataset: Optional[NamedEntity] = None
    subset: Optional[NamedEntity] = None
    pipeline: Optional[NamedEntity] = None
    state: PipelineRunState
    started_at: Optional[int] = Field(None, title="Started At")
    finished_at: Optional[int] = Field(None, title="Finished At")
    index_in_pipeline: int = Field(..., title="Index In Pipeline")
    progress_report: Optional[Dict[str, Any]] = Field(None, title="Progress Report")
    error_message: Optional[str] = Field(None, title="Error Message")


class PipelineRunListResponse(BaseModel):
    filter: FilterResponse
    items: List[PipelineRunResponse] = Field(..., title="Items")


class RequiredContextDescription(BaseModel):
    pipeline_node_id: int = Field(..., title="Pipeline Node Id")
    context_name: str = Field(..., title="Context Name")
    context_type: Dict[str, Any] = Field(..., title="Context Type")


class RequiredContextResponse(BaseModel):
    items: List[RequiredContextDescription] = Field(..., title="Items")


class SubsetResponse(BaseModel):
    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    observation_ids: List[int] = Field(..., title="Observation Ids")
    pipeline_run_ids: List[int] = Field(..., title="Pipeline Run Ids")


class SubsetCreateRequest(BaseModel):
    name: str = Field(..., title="Name")
    dataset_id: int = Field(..., title="Dataset Id")
    observation_ids: List[int] = Field(..., title="Observation Ids")


class SubsetUpdateRequest(BaseModel):
    observation_ids: List[int] = Field(..., title="Observation Ids")
    name: Optional[str] = Field(None, title="Name")


class ListSubsetResponse(BaseModel):
    subsets: List[SubsetResponse] = Field(..., title="Subsets")


class ObservationResponse(BaseModel):
    id: int = Field(..., title="Id")
    type: str = Field(..., title="Type")
    file_name: str = Field(..., title="File Name")
    odd_tags: List[str] = Field(..., title="Odd Tags")
    file_url: Optional[str] = Field(None, title="File Url")
    created_at: Optional[str] = Field(None, title="Created At")


class DatasetResponse(BaseModel):
    id: int = Field(..., title="Id")
    name: str = Field(..., title="Name")
    type: str = Field(..., title="Type")
    observation_ids: List[int] = Field(..., title="Observation Ids")


class ObservationType(Enum):
    """
    Identification of the type of an observation.

    Required for parsing an observation into a core-object.
    """

    TEXT = "TEXT"
    COLOR_IMAGE = "COLOR_IMAGE"
    GREY_SCALE_IMAGE = "GREY_SCALE_IMAGE"


class DatasetUploadRequest(BaseModel):
    name: str = Field(..., title="Name")
    type: ObservationType


class ListDatasetResponse(BaseModel):
    filter: FilterResponse
    items: List[DatasetResponse] = Field(..., title="Items")


class ReportRequest(BaseModel):
    """
    Model for the request to the only report endpoint.
    """

    model: int = Field(..., title="Model")
    model_versions: List[int] = Field(..., title="Model Versions")
    dataset: int = Field(..., title="Dataset")
    subset: int = Field(..., title="Subset")
    metrics: List[str] = Field(..., title="Metrics")
    success_metric_threshold: float = Field(..., title="Success Metric Threshold")


class OutputType(Enum):
    """
    Identification of the output type of a model or of the annotation.
    """

    CLASSIFICATION = "CLASSIFICATION"
    SEGMENTATION = "SEGMENTATION"
    DETECTION = "DETECTION"


class CorruptionReportPlotRecipes(BaseModel):
    """
    Class containing all corruption report plot recipes represented as
    dictionaries.
    """

    model_comparison_mfr: Dict[str, Any] = Field(..., title="Model comparison MFR plot.")
    odd_comparison_mfr: Dict[str, Any] = Field(..., title="ODD comparison MFR plot.")


class ModelNormStats(BaseModel):
    """
    Pydantic model containing the statistics for a model version and distance
    metric.
    """

    impact: float = Field(..., title="Impact")
    vulnerability: float = Field(..., title="Vulnerability")
    p_damage: float = Field(..., title="P Damage")


class CorruptionReportStats(BaseModel):
    """
    Pydantic model containing the summary statistics of corruption data for the
    model-comparison view.
    """

    model_comparison_stats: Dict[
        str, Dict[str, Dict[str, Dict[str, Dict[str, Dict[str, ModelNormStats]]]]]
    ] = Field(..., title="Model Comparison Stats")


class ReportCorruptionResponse(BaseModel):
    """
    Server response for the corruption report endpoint.
    """

    data: Dict[str, List] = Field(..., title="Data")
    output_type: OutputType
    observations_to_odd_tags: Dict[str, List[str]] = Field(..., title="Observations To Odd Tags")
    plot_recipes: CorruptionReportPlotRecipes
    stats: CorruptionReportStats


class AdversarialReportPlotRecipes(BaseModel):
    """
    Class containing all adversarial report plot recipes represented as
    dictionaries.
    """

    model_comparison_asr: Dict[str, Any] = Field(..., title="Model Comparison Asr")
    attack_comparison_asr: Dict[str, Any] = Field(..., title="Attack Comparison Asr")
    attack_detail_asr: Dict[str, Any] = Field(..., title="Attack Detail Asr")


class AdversarialReportStats(BaseModel):
    """
    Pydantic model containing the summary statistics for the model-comparison
    and the attack-comparison view.
    """

    model_comparison_stats: Dict[str, Dict[str, Dict[str, Dict[str, ModelNormStats]]]] = Field(
        ..., title="Model Comparison Stats"
    )
    attack_comparison_stats: Dict[
        str, Dict[str, Dict[str, Dict[str, Dict[str, Dict[str, ModelNormStats]]]]]
    ] = Field(..., title="Attack Comparison Stats")


class ReportAdversarialResponse(BaseModel):
    """
    Server response for the adversarial report endpoint.
    """

    data: Dict[str, List] = Field(..., title="Data")
    output_type: OutputType
    plot_recipes: AdversarialReportPlotRecipes
    stats: AdversarialReportStats


class DimensionType(Enum):
    """
    An enumeration of dimension types.
    """

    width = "width"
    height = "height"
    batch = "batch"
    channel = "channel"
    feature = "feature"
    index = "index"
    string = "string"
    class_ = "class_"
    proposal = "proposal"
    coordinate = "coordinate"
    box_info = "box_info"


class ClassificationModelOutput(BaseModel):
    """
    Class for outputs of classification models.

    Classification output is returned in shape (class,), where the
    entries along the class dimension are softmax scores.
    """

    name: Literal["ClassificationModelOutput"] = Field(
        "ClassificationModelOutput", title="ClassificationModelOutput"
    )
    dimensions: List[DimensionType]
    class_names: List[str] = Field(..., title="Class Names")
    data: List[float] = Field(..., title="Data")


class Dimension(BaseModel):
    __root__: List[Any] = Field(..., max_items=3, min_items=3)


class Dimension1(BaseModel):
    __root__: List[Any] = Field(..., max_items=3, min_items=3)


class Dimension2(BaseModel):
    __root__: List[Any] = Field(..., max_items=3, min_items=3)


class Dimension3(BaseModel):
    __root__: List[Any] = Field(..., max_items=3, min_items=3)


class Dimension4(BaseModel):
    __root__: List[Any] = Field(..., max_items=3, min_items=3)


class Dimension5(BaseModel):
    __root__: List[Any] = Field(..., max_items=3, min_items=3)


class ImageSegmentationModelOutput(BaseModel):
    """
    Class for outputs of image segmentation models.

    Segmentation maps are returned in shape (height, width, class).
    """

    name: Literal["ImageSegmentationModelOutput"] = Field(
        "ImageSegmentationModelOutput", title="ImageSegmentationModelOutput"
    )
    dimensions: Union[
        Dimension, Dimension1, Dimension2, Dimension3, Dimension4, Dimension5
    ] = Field(..., title="Dimensions")
    class_names: List[str] = Field(..., title="Class Names")
    data: List[List[List[float]]] = Field(..., title="Data")


class ImageObjectDetectionBoundingBox(BaseModel):
    """
    A single bounding box detected by an object detection model.

    Bounding boxes are returned in shape (6,), where the first 4 entries
    correspond to the bounding box coordinates, and the last 2 are the
    confidence score and the class index. The bounding box coordinates
    are supplied as x_min, y_min, x_max, y_max.
    """

    min_x: float = Field(..., ge=-0.09, title="Absolute x-coordinate of the bottom left corner")
    min_y: float = Field(..., ge=-0.09, title="Absolute y-coordinate of the bottom left corner")
    max_x: float = Field(..., ge=-0.09, title="Absolute x-coordinate of the top right corner")
    max_y: float = Field(..., ge=-0.09, title="Absolute y-coordinate of the top right corner")
    class_index: int = Field(..., ge=0.0, title="Class Index")
    confidence: float = Field(..., ge=0.0, title="Confidence")


class ImageObjectDetectionModelOutput(BaseModel):
    """
    Class for outputs of image object detection models.

    Detection model output is returned in shape (batch, 6), where
    "batch" refers to the number of objects and "6" is the length of a
    single `ImageObjectDetectionBoundingBox`.
    """

    name: Literal["ImageObjectDetectionModelOutput"] = Field(
        "ImageObjectDetectionModelOutput", title="ImageObjectDetectionModelOutput"
    )
    dimensions: List[Union[Literal["batch"], Literal["box_info"]]] = Field(
        ..., max_items=2, min_items=2, title="Dimensions"
    )
    class_names: List[str] = Field(..., title="Class Names")
    data: List[ImageObjectDetectionBoundingBox] = Field(..., title="Data")


class ReportCoreMethodOutputDetailResponse(BaseModel):
    """
    Server response for the report detail view endpoint.
    """

    observation_id: int = Field(..., title="Observation Id")
    observation_inference_result: Union[
        ClassificationModelOutput, ImageSegmentationModelOutput, ImageObjectDetectionModelOutput
    ] = Field(..., title="Observation Inference Result")
    core_method_output_type: str = Field(..., title="Core Method Output Type")
    core_method_output_storage_url: str = Field(..., title="Core Method Output Storage Url")
    core_method_output_id: int = Field(..., title="Core Method Output Id")
    core_method_output_inference_result: Union[
        ClassificationModelOutput, ImageSegmentationModelOutput, ImageObjectDetectionModelOutput
    ] = Field(..., title="Core Method Output Inference Result")


class _ModelCompilation(BaseModel):
    ml_model_version_response: MLModelVersionResponse
    list_ml_model_version_response: ListMLModelVersionResponse
    ml_model_creation_request_for_schema: MLModelCreationRequestForSchema
    ml_model_response: MLModelResponse
    list_ml_model_response: ListMLModelResponse
    create_pipeline_run_request: CreatePipelineRunRequest
    pipeline_run_response: PipelineRunResponse
    pipeline_run_list_response: PipelineRunListResponse
    required_context_response: RequiredContextResponse
    subset_response: SubsetResponse
    subset_create_request: SubsetCreateRequest
    subset_update_request: SubsetUpdateRequest
    list_subset_response: ListSubsetResponse
    observation_response: ObservationResponse
    dataset_response: DatasetResponse
    dataset_request: DatasetUploadRequest
    list_dataset_response: ListDatasetResponse
    report_request: ReportRequest
    report_corruption_response: ReportCorruptionResponse
    report_adversarial_response: ReportAdversarialResponse
    report_adversarial_example_detail_response: ReportCoreMethodOutputDetailResponse
