import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * If false then no one can connect to this database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#allow_connections Database#allow_connections}
     *
     * @stability stable
     */
    readonly allowConnections?: boolean | cdktf.IResolvable;
    /**
     * How many concurrent connections can be made to this database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#connection_limit Database#connection_limit}
     *
     * @stability stable
     */
    readonly connectionLimit?: number;
    /**
     * Character set encoding to use in the new database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#encoding Database#encoding}
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * If true, then this database can be cloned by any user with CREATEDB privileges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#is_template Database#is_template}
     *
     * @stability stable
     */
    readonly isTemplate?: boolean | cdktf.IResolvable;
    /**
     * Collation order (LC_COLLATE) to use in the new database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#lc_collate Database#lc_collate}
     *
     * @stability stable
     */
    readonly lcCollate?: string;
    /**
     * Character classification (LC_CTYPE) to use in the new database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#lc_ctype Database#lc_ctype}
     *
     * @stability stable
     */
    readonly lcCtype?: string;
    /**
     * The PostgreSQL database name to connect to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#name Database#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ROLE which owns the database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#owner Database#owner}
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * The name of the tablespace that will be associated with the new database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#tablespace_name Database#tablespace_name}
     *
     * @stability stable
     */
    readonly tablespaceName?: string;
    /**
     * The name of the template from which to create the new database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database.html#template Database#template}
     *
     * @stability stable
     */
    readonly template?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/database.html postgresql_database}.
 *
 * @stability stable
 */
export declare class Database extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/database.html postgresql_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DatabaseConfig);
    private _allowConnections?;
    /**
     * @stability stable
     */
    get allowConnections(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowConnections(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowConnections(): void;
    /**
     * @stability stable
     */
    get allowConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _connectionLimit?;
    /**
     * @stability stable
     */
    get connectionLimit(): number;
    /**
     * @stability stable
     */
    set connectionLimit(value: number);
    /**
     * @stability stable
     */
    resetConnectionLimit(): void;
    /**
     * @stability stable
     */
    get connectionLimitInput(): number | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isTemplate?;
    /**
     * @stability stable
     */
    get isTemplate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isTemplate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsTemplate(): void;
    /**
     * @stability stable
     */
    get isTemplateInput(): boolean | cdktf.IResolvable | undefined;
    private _lcCollate?;
    /**
     * @stability stable
     */
    get lcCollate(): string;
    /**
     * @stability stable
     */
    set lcCollate(value: string);
    /**
     * @stability stable
     */
    resetLcCollate(): void;
    /**
     * @stability stable
     */
    get lcCollateInput(): string | undefined;
    private _lcCtype?;
    /**
     * @stability stable
     */
    get lcCtype(): string;
    /**
     * @stability stable
     */
    set lcCtype(value: string);
    /**
     * @stability stable
     */
    resetLcCtype(): void;
    /**
     * @stability stable
     */
    get lcCtypeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    private _tablespaceName?;
    /**
     * @stability stable
     */
    get tablespaceName(): string;
    /**
     * @stability stable
     */
    set tablespaceName(value: string);
    /**
     * @stability stable
     */
    resetTablespaceName(): void;
    /**
     * @stability stable
     */
    get tablespaceNameInput(): string | undefined;
    private _template?;
    /**
     * @stability stable
     */
    get template(): string;
    /**
     * @stability stable
     */
    set template(value: string);
    /**
     * @stability stable
     */
    resetTemplate(): void;
    /**
     * @stability stable
     */
    get templateInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
