import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GrantRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the role that is granted to role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role#grant_role GrantRole#grant_role}
     *
     * @stability stable
     */
    readonly grantRole: string;
    /**
     * The name of the role to grant grant_role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role#role GrantRole#role}
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Permit the grant recipient to grant it to others.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role#with_admin_option GrantRole#with_admin_option}
     *
     * @stability stable
     */
    readonly withAdminOption?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role postgresql_grant_role}.
 *
 * @stability stable
 */
export declare class GrantRole extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role postgresql_grant_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GrantRoleConfig);
    private _grantRole?;
    /**
     * @stability stable
     */
    get grantRole(): string;
    /**
     * @stability stable
     */
    set grantRole(value: string);
    /**
     * @stability stable
     */
    get grantRoleInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _withAdminOption?;
    /**
     * @stability stable
     */
    get withAdminOption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set withAdminOption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWithAdminOption(): void;
    /**
     * @stability stable
     */
    get withAdminOptionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
