import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * If false then no one can connect to this database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#allow_connections Database#allow_connections}
    */
    readonly allowConnections?: boolean | cdktf.IResolvable;
    /**
    * How many concurrent connections can be made to this database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#connection_limit Database#connection_limit}
    */
    readonly connectionLimit?: number;
    /**
    * Character set encoding to use in the new database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#encoding Database#encoding}
    */
    readonly encoding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#id Database#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If true, then this database can be cloned by any user with CREATEDB privileges
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#is_template Database#is_template}
    */
    readonly isTemplate?: boolean | cdktf.IResolvable;
    /**
    * Collation order (LC_COLLATE) to use in the new database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#lc_collate Database#lc_collate}
    */
    readonly lcCollate?: string;
    /**
    * Character classification (LC_CTYPE) to use in the new database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#lc_ctype Database#lc_ctype}
    */
    readonly lcCtype?: string;
    /**
    * The PostgreSQL database name to connect to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#name Database#name}
    */
    readonly name: string;
    /**
    * The ROLE which owns the database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#owner Database#owner}
    */
    readonly owner?: string;
    /**
    * The name of the tablespace that will be associated with the new database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#tablespace_name Database#tablespace_name}
    */
    readonly tablespaceName?: string;
    /**
    * The name of the template from which to create the new database
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/database#template Database#template}
    */
    readonly template?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/database postgresql_database}
*/
export declare class Database extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/database postgresql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseConfig);
    private _allowConnections?;
    get allowConnections(): boolean | cdktf.IResolvable;
    set allowConnections(value: boolean | cdktf.IResolvable);
    resetAllowConnections(): void;
    get allowConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _connectionLimit?;
    get connectionLimit(): number;
    set connectionLimit(value: number);
    resetConnectionLimit(): void;
    get connectionLimitInput(): number | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isTemplate?;
    get isTemplate(): boolean | cdktf.IResolvable;
    set isTemplate(value: boolean | cdktf.IResolvable);
    resetIsTemplate(): void;
    get isTemplateInput(): boolean | cdktf.IResolvable | undefined;
    private _lcCollate?;
    get lcCollate(): string;
    set lcCollate(value: string);
    resetLcCollate(): void;
    get lcCollateInput(): string | undefined;
    private _lcCtype?;
    get lcCtype(): string;
    set lcCtype(value: string);
    resetLcCtype(): void;
    get lcCtypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _tablespaceName?;
    get tablespaceName(): string;
    set tablespaceName(value: string);
    resetTablespaceName(): void;
    get tablespaceNameInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    resetTemplate(): void;
    get templateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
