"""
CellPyLib
=========

CellPyLib is a library for working with Cellular Automata.

For complete documentation, see: https://cellpylib.org
"""

__version__ = "2.3.0"

from .ca_functions import BaseRule, AsynchronousRule, ReversibleRule, binary_rule, init_simple, nks_rule, \
    totalistic_rule, plot_multiple, bits_to_int, int_to_bits, init_random, plot, evolve, until_fixed_point, NKSRule, \
    BinaryRule, TotalisticRule

from .rule_tables import random_rule_table, table_walk_through, table_rule

from .entropy import mutual_information, average_cell_entropy, average_mutual_information, shannon_entropy, \
    joint_shannon_entropy

from .ca_functions2d import evolve2d, plot2d, plot2d_slice, plot2d_animate, plot2d_spacetime, init_simple2d, \
    init_random2d, game_of_life_rule

from .bien import binary_derivative, cyclic_binary_derivative, ktbien, tbien, bien

from .apen import apen

from .hopfield_net import HopfieldNet

from .ctrbl_rule import CTRBLRule

from .langtons_loop import LangtonsLoop

from .sdsr_loop import SDSRLoop

from .evoloop import Evoloop

from .sandpile import Sandpile
