# Generated by Django 3.2.11 on 2022-01-07 07:52

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Notification",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True, verbose_name="Created at")),
                ("delayed_sending_at", models.DateTimeField(blank=True, null=True, verbose_name="Delayed sending at")),
                ("sent_at", models.DateTimeField(blank=True, editable=False, null=True, verbose_name="Sent at")),
                ("subject", models.CharField(max_length=255, verbose_name="Subject")),
                ("text_body", models.TextField(verbose_name="Text body")),
                ("html_body", models.TextField(verbose_name="HTML body")),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                ("state_from", models.CharField(blank=True, default="", max_length=255, verbose_name="State from")),
                ("state_to", models.CharField(blank=True, default="", max_length=255, verbose_name="State to")),
                (
                    "email_recipients",
                    models.TextField(blank=True, help_text="One email per line", verbose_name="Email recipients"),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=1,
                        editable=False,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Created by",
                    ),
                ),
                (
                    "recipients",
                    models.ManyToManyField(
                        blank=True, related_name="notifications", to=settings.AUTH_USER_MODEL, verbose_name="Recipients"
                    ),
                ),
            ],
            options={
                "verbose_name": "Notification",
                "verbose_name_plural": "Notifications",
            },
        ),
        migrations.CreateModel(
            name="Attachment",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("attachment_file", models.FileField(upload_to="notifications/attachments/%Y/%m/%d/")),
                (
                    "notification",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachments",
                        to="django_notifications.notification",
                    ),
                ),
            ],
            options={
                "verbose_name": "Attachment",
                "verbose_name_plural": "Attachments",
                "ordering": ("notification", "id"),
            },
        ),
    ]
