# mypy-boto3-route53

[![PyPI - mypy-boto3-route53](https://img.shields.io/pypi/v/mypy-boto3-route53.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-route53.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Route53 1.16.45](https://boto3.amazonaws.com/v1/documentation/api/1.16.45/reference/services/route53.html#Route53) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-route53](#mypy-boto3-route53)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Route53` service.

```bash
python -m pip install boto3-stubs[route53]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[route53]` in your environment: `python -m pip install 'boto3-stubs[route53]'`

Both type checking and auto-complete should work for `Route53` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[route53]` in your environment: `python -m pip install 'boto3-stubs[route53]'`

Both type checking and auto-complete should work for `Route53` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[route53]` in your environment: `python -m pip install 'boto3-stubs[route53]'`
- Run `mypy` as usual

Type checking should work for `Route53` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[route53]` in your environment: `python -m pip install 'boto3-stubs[route53]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Route53` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`Route53Client` provides annotations for `boto3.client("route53")`.

```python
import boto3

from mypy_boto3_route53 import Route53Client

client: Route53Client = boto3.client("route53")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: Route53Client = session.client("route53")
```

### Paginators annotations

`mypy_boto3_route53.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_route53 import Route53Client
from mypy_boto3_route53.paginator import (
    ListHealthChecksPaginator,
    ListHostedZonesPaginator,
    ListQueryLoggingConfigsPaginator,
    ListResourceRecordSetsPaginator,
    ListVPCAssociationAuthorizationsPaginator,
)

client: Route53Client = boto3.client("route53")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_health_checks_paginator: ListHealthChecksPaginator = client.get_paginator("list_health_checks")
list_hosted_zones_paginator: ListHostedZonesPaginator = client.get_paginator("list_hosted_zones")
list_query_logging_configs_paginator: ListQueryLoggingConfigsPaginator = client.get_paginator("list_query_logging_configs")
list_resource_record_sets_paginator: ListResourceRecordSetsPaginator = client.get_paginator("list_resource_record_sets")
list_vpc_association_authorizations_paginator: ListVPCAssociationAuthorizationsPaginator = client.get_paginator("list_vpc_association_authorizations")
```


### Waiters annotations

`mypy_boto3_route53.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_route53 import Route53Client
from mypy_boto3_route53.waiter import ResourceRecordSetsChangedWaiter

client: Route53Client = boto3.client("route53")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
resource_record_sets_changed_waiter: ResourceRecordSetsChangedWaiter = client.get_waiter("resource_record_sets_changed")
```





### Typed dictionations

`mypy_boto3_route53.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_route53.type_defs import (
    AccountLimitTypeDef,
    ActivateKeySigningKeyResponseTypeDef,
    AlarmIdentifierTypeDef,
    AliasTargetTypeDef,
    AssociateVPCWithHostedZoneResponseTypeDef,
    ChangeBatchTypeDef,
    ChangeInfoTypeDef,
    ChangeResourceRecordSetsResponseTypeDef,
    ChangeTypeDef,
    CloudWatchAlarmConfigurationTypeDef,
    CreateHealthCheckResponseTypeDef,
    CreateHostedZoneResponseTypeDef,
    CreateKeySigningKeyResponseTypeDef,
    CreateQueryLoggingConfigResponseTypeDef,
    CreateReusableDelegationSetResponseTypeDef,
    CreateTrafficPolicyInstanceResponseTypeDef,
    CreateTrafficPolicyResponseTypeDef,
    CreateTrafficPolicyVersionResponseTypeDef,
    CreateVPCAssociationAuthorizationResponseTypeDef,
    DeactivateKeySigningKeyResponseTypeDef,
    DelegationSetTypeDef,
    DeleteHostedZoneResponseTypeDef,
    DeleteKeySigningKeyResponseTypeDef,
    DimensionTypeDef,
    DisableHostedZoneDNSSECResponseTypeDef,
    DisassociateVPCFromHostedZoneResponseTypeDef,
    DNSSECStatusTypeDef,
    EnableHostedZoneDNSSECResponseTypeDef,
    GeoLocationDetailsTypeDef,
    GeoLocationTypeDef,
    GetAccountLimitResponseTypeDef,
    GetChangeResponseTypeDef,
    GetCheckerIpRangesResponseTypeDef,
    GetDNSSECResponseTypeDef,
    GetGeoLocationResponseTypeDef,
    GetHealthCheckCountResponseTypeDef,
    GetHealthCheckLastFailureReasonResponseTypeDef,
    GetHealthCheckResponseTypeDef,
    GetHealthCheckStatusResponseTypeDef,
    GetHostedZoneCountResponseTypeDef,
    GetHostedZoneLimitResponseTypeDef,
    GetHostedZoneResponseTypeDef,
    GetQueryLoggingConfigResponseTypeDef,
    GetReusableDelegationSetLimitResponseTypeDef,
    GetReusableDelegationSetResponseTypeDef,
    GetTrafficPolicyInstanceCountResponseTypeDef,
    GetTrafficPolicyInstanceResponseTypeDef,
    GetTrafficPolicyResponseTypeDef,
    HealthCheckConfigTypeDef,
    HealthCheckObservationTypeDef,
    HealthCheckTypeDef,
    HostedZoneConfigTypeDef,
    HostedZoneLimitTypeDef,
    HostedZoneOwnerTypeDef,
    HostedZoneSummaryTypeDef,
    HostedZoneTypeDef,
    KeySigningKeyTypeDef,
    LinkedServiceTypeDef,
    ListGeoLocationsResponseTypeDef,
    ListHealthChecksResponseTypeDef,
    ListHostedZonesByNameResponseTypeDef,
    ListHostedZonesByVPCResponseTypeDef,
    ListHostedZonesResponseTypeDef,
    ListQueryLoggingConfigsResponseTypeDef,
    ListResourceRecordSetsResponseTypeDef,
    ListReusableDelegationSetsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTagsForResourcesResponseTypeDef,
    ListTrafficPoliciesResponseTypeDef,
    ListTrafficPolicyInstancesByHostedZoneResponseTypeDef,
    ListTrafficPolicyInstancesByPolicyResponseTypeDef,
    ListTrafficPolicyInstancesResponseTypeDef,
    ListTrafficPolicyVersionsResponseTypeDef,
    ListVPCAssociationAuthorizationsResponseTypeDef,
    PaginatorConfigTypeDef,
    QueryLoggingConfigTypeDef,
    ResourceRecordSetTypeDef,
    ResourceRecordTypeDef,
    ResourceTagSetTypeDef,
    ReusableDelegationSetLimitTypeDef,
    StatusReportTypeDef,
    TagTypeDef,
    TestDNSAnswerResponseTypeDef,
    TrafficPolicyInstanceTypeDef,
    TrafficPolicySummaryTypeDef,
    TrafficPolicyTypeDef,
    UpdateHealthCheckResponseTypeDef,
    UpdateHostedZoneCommentResponseTypeDef,
    UpdateTrafficPolicyCommentResponseTypeDef,
    UpdateTrafficPolicyInstanceResponseTypeDef,
    VPCTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccountLimitTypeDef:
    return {
      ...
    }
```
