<a id="mypy-boto3-route53"></a>

# mypy-boto3-route53

[![PyPI - mypy-boto3-route53](https://img.shields.io/pypi/v/mypy-boto3-route53.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-route53.svg?color=blue)](https://pypi.org/project/mypy-boto3-route53)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-route53?color=blue)](https://pypistats.org/packages/mypy-boto3-route53)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Route53 1.19.2](https://boto3.amazonaws.com/v1/documentation/api/1.19.2/reference/services/route53.html#Route53)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-route53 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-route53](#mypy-boto3-route53)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Route53` service.

```bash
python -m pip install boto3-stubs[route53]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[route53]` in your environment:
  `python -m pip install 'boto3-stubs[route53]'`

Both type checking and auto-complete should work for `Route53` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[route53]` in your environment:
  `python -m pip install 'boto3-stubs[route53]'`

Both type checking and auto-complete should work for `Route53` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[route53]` in your environment:
  `python -m pip install 'boto3-stubs[route53]'`
- Run `mypy` as usual

Type checking should work for `Route53` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[route53]` in your environment:
  `python -m pip install 'boto3-stubs[route53]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Route53` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`Route53Client` provides annotations for `boto3.client("route53")`.

```python
import boto3

from mypy_boto3_route53 import Route53Client

client: Route53Client = boto3.client("route53")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: Route53Client = session.client("route53")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_route53.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_route53 import Route53Client
from mypy_boto3_route53.paginator import (
    ListHealthChecksPaginator,
    ListHostedZonesPaginator,
    ListQueryLoggingConfigsPaginator,
    ListResourceRecordSetsPaginator,
    ListVPCAssociationAuthorizationsPaginator,
)

client: Route53Client = boto3.client("route53")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_health_checks_paginator: ListHealthChecksPaginator = client.get_paginator("list_health_checks")
list_hosted_zones_paginator: ListHostedZonesPaginator = client.get_paginator("list_hosted_zones")
list_query_logging_configs_paginator: ListQueryLoggingConfigsPaginator = client.get_paginator("list_query_logging_configs")
list_resource_record_sets_paginator: ListResourceRecordSetsPaginator = client.get_paginator("list_resource_record_sets")
list_vpc_association_authorizations_paginator: ListVPCAssociationAuthorizationsPaginator = client.get_paginator("list_vpc_association_authorizations")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_route53.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_route53 import Route53Client
from mypy_boto3_route53.waiter import (
    ResourceRecordSetsChangedWaiter,
)

client: Route53Client = boto3.client("route53")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
resource_record_sets_changed_waiter: ResourceRecordSetsChangedWaiter = client.get_waiter("resource_record_sets_changed")
```

<a id="literals"></a>

### Literals

`mypy_boto3_route53.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_route53.literals import (
    AccountLimitTypeType,
    ChangeActionType,
    ChangeStatusType,
    CloudWatchRegionType,
    ComparisonOperatorType,
    HealthCheckRegionType,
    HealthCheckTypeType,
    HostedZoneLimitTypeType,
    InsufficientDataHealthStatusType,
    ListHealthChecksPaginatorName,
    ListHostedZonesPaginatorName,
    ListQueryLoggingConfigsPaginatorName,
    ListResourceRecordSetsPaginatorName,
    ListVPCAssociationAuthorizationsPaginatorName,
    RRTypeType,
    ResettableElementNameType,
    ResourceRecordSetFailoverType,
    ResourceRecordSetRegionType,
    ResourceRecordSetsChangedWaiterName,
    ReusableDelegationSetLimitTypeType,
    StatisticType,
    TagResourceTypeType,
    VPCRegionType,
    ServiceName,
    PaginatorName,
    WaiterName,
)

def check_value(value: AccountLimitTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_route53.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_route53.type_defs import (
    AccountLimitTypeDef,
    ActivateKeySigningKeyRequestRequestTypeDef,
    ActivateKeySigningKeyResponseTypeDef,
    AlarmIdentifierTypeDef,
    AliasTargetTypeDef,
    AssociateVPCWithHostedZoneRequestRequestTypeDef,
    AssociateVPCWithHostedZoneResponseTypeDef,
    ChangeBatchTypeDef,
    ChangeInfoTypeDef,
    ChangeResourceRecordSetsRequestRequestTypeDef,
    ChangeResourceRecordSetsResponseTypeDef,
    ChangeTagsForResourceRequestRequestTypeDef,
    ChangeTypeDef,
    CloudWatchAlarmConfigurationTypeDef,
    CreateHealthCheckRequestRequestTypeDef,
    CreateHealthCheckResponseTypeDef,
    CreateHostedZoneRequestRequestTypeDef,
    CreateHostedZoneResponseTypeDef,
    CreateKeySigningKeyRequestRequestTypeDef,
    CreateKeySigningKeyResponseTypeDef,
    CreateQueryLoggingConfigRequestRequestTypeDef,
    CreateQueryLoggingConfigResponseTypeDef,
    CreateReusableDelegationSetRequestRequestTypeDef,
    CreateReusableDelegationSetResponseTypeDef,
    CreateTrafficPolicyInstanceRequestRequestTypeDef,
    CreateTrafficPolicyInstanceResponseTypeDef,
    CreateTrafficPolicyRequestRequestTypeDef,
    CreateTrafficPolicyResponseTypeDef,
    CreateTrafficPolicyVersionRequestRequestTypeDef,
    CreateTrafficPolicyVersionResponseTypeDef,
    CreateVPCAssociationAuthorizationRequestRequestTypeDef,
    CreateVPCAssociationAuthorizationResponseTypeDef,
    DNSSECStatusTypeDef,
    DeactivateKeySigningKeyRequestRequestTypeDef,
    DeactivateKeySigningKeyResponseTypeDef,
    DelegationSetTypeDef,
    DeleteHealthCheckRequestRequestTypeDef,
    DeleteHostedZoneRequestRequestTypeDef,
    DeleteHostedZoneResponseTypeDef,
    DeleteKeySigningKeyRequestRequestTypeDef,
    DeleteKeySigningKeyResponseTypeDef,
    DeleteQueryLoggingConfigRequestRequestTypeDef,
    DeleteReusableDelegationSetRequestRequestTypeDef,
    DeleteTrafficPolicyInstanceRequestRequestTypeDef,
    DeleteTrafficPolicyRequestRequestTypeDef,
    DeleteVPCAssociationAuthorizationRequestRequestTypeDef,
    DimensionTypeDef,
    DisableHostedZoneDNSSECRequestRequestTypeDef,
    DisableHostedZoneDNSSECResponseTypeDef,
    DisassociateVPCFromHostedZoneRequestRequestTypeDef,
    DisassociateVPCFromHostedZoneResponseTypeDef,
    EnableHostedZoneDNSSECRequestRequestTypeDef,
    EnableHostedZoneDNSSECResponseTypeDef,
    GeoLocationDetailsTypeDef,
    GeoLocationTypeDef,
    GetAccountLimitRequestRequestTypeDef,
    GetAccountLimitResponseTypeDef,
    GetChangeRequestRequestTypeDef,
    GetChangeResponseTypeDef,
    GetCheckerIpRangesResponseTypeDef,
    GetDNSSECRequestRequestTypeDef,
    GetDNSSECResponseTypeDef,
    GetGeoLocationRequestRequestTypeDef,
    GetGeoLocationResponseTypeDef,
    GetHealthCheckCountResponseTypeDef,
    GetHealthCheckLastFailureReasonRequestRequestTypeDef,
    GetHealthCheckLastFailureReasonResponseTypeDef,
    GetHealthCheckRequestRequestTypeDef,
    GetHealthCheckResponseTypeDef,
    GetHealthCheckStatusRequestRequestTypeDef,
    GetHealthCheckStatusResponseTypeDef,
    GetHostedZoneCountResponseTypeDef,
    GetHostedZoneLimitRequestRequestTypeDef,
    GetHostedZoneLimitResponseTypeDef,
    GetHostedZoneRequestRequestTypeDef,
    GetHostedZoneResponseTypeDef,
    GetQueryLoggingConfigRequestRequestTypeDef,
    GetQueryLoggingConfigResponseTypeDef,
    GetReusableDelegationSetLimitRequestRequestTypeDef,
    GetReusableDelegationSetLimitResponseTypeDef,
    GetReusableDelegationSetRequestRequestTypeDef,
    GetReusableDelegationSetResponseTypeDef,
    GetTrafficPolicyInstanceCountResponseTypeDef,
    GetTrafficPolicyInstanceRequestRequestTypeDef,
    GetTrafficPolicyInstanceResponseTypeDef,
    GetTrafficPolicyRequestRequestTypeDef,
    GetTrafficPolicyResponseTypeDef,
    HealthCheckConfigTypeDef,
    HealthCheckObservationTypeDef,
    HealthCheckTypeDef,
    HostedZoneConfigTypeDef,
    HostedZoneLimitTypeDef,
    HostedZoneOwnerTypeDef,
    HostedZoneSummaryTypeDef,
    HostedZoneTypeDef,
    KeySigningKeyTypeDef,
    LinkedServiceTypeDef,
    ListGeoLocationsRequestRequestTypeDef,
    ListGeoLocationsResponseTypeDef,
    ListHealthChecksRequestRequestTypeDef,
    ListHealthChecksResponseTypeDef,
    ListHostedZonesByNameRequestRequestTypeDef,
    ListHostedZonesByNameResponseTypeDef,
    ListHostedZonesByVPCRequestRequestTypeDef,
    ListHostedZonesByVPCResponseTypeDef,
    ListHostedZonesRequestRequestTypeDef,
    ListHostedZonesResponseTypeDef,
    ListQueryLoggingConfigsRequestRequestTypeDef,
    ListQueryLoggingConfigsResponseTypeDef,
    ListResourceRecordSetsRequestRequestTypeDef,
    ListResourceRecordSetsResponseTypeDef,
    ListReusableDelegationSetsRequestRequestTypeDef,
    ListReusableDelegationSetsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTagsForResourcesRequestRequestTypeDef,
    ListTagsForResourcesResponseTypeDef,
    ListTrafficPoliciesRequestRequestTypeDef,
    ListTrafficPoliciesResponseTypeDef,
    ListTrafficPolicyInstancesByHostedZoneRequestRequestTypeDef,
    ListTrafficPolicyInstancesByHostedZoneResponseTypeDef,
    ListTrafficPolicyInstancesByPolicyRequestRequestTypeDef,
    ListTrafficPolicyInstancesByPolicyResponseTypeDef,
    ListTrafficPolicyInstancesRequestRequestTypeDef,
    ListTrafficPolicyInstancesResponseTypeDef,
    ListTrafficPolicyVersionsRequestRequestTypeDef,
    ListTrafficPolicyVersionsResponseTypeDef,
    ListVPCAssociationAuthorizationsRequestRequestTypeDef,
    ListVPCAssociationAuthorizationsResponseTypeDef,
    PaginatorConfigTypeDef,
    QueryLoggingConfigTypeDef,
    ResourceRecordSetTypeDef,
    ResourceRecordTypeDef,
    ResourceTagSetTypeDef,
    ResponseMetadataTypeDef,
    ReusableDelegationSetLimitTypeDef,
    StatusReportTypeDef,
    TagTypeDef,
    TestDNSAnswerRequestRequestTypeDef,
    TestDNSAnswerResponseTypeDef,
    TrafficPolicyInstanceTypeDef,
    TrafficPolicySummaryTypeDef,
    TrafficPolicyTypeDef,
    UpdateHealthCheckRequestRequestTypeDef,
    UpdateHealthCheckResponseTypeDef,
    UpdateHostedZoneCommentRequestRequestTypeDef,
    UpdateHostedZoneCommentResponseTypeDef,
    UpdateTrafficPolicyCommentRequestRequestTypeDef,
    UpdateTrafficPolicyCommentResponseTypeDef,
    UpdateTrafficPolicyInstanceRequestRequestTypeDef,
    UpdateTrafficPolicyInstanceResponseTypeDef,
    VPCTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccountLimitTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-route53` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-route53 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_route53/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
