"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.Secret = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType = exports.ImageRepositoryType || (exports.ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) { return new Cpu(unit); }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.62.0-alpha.0" };
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) { return new Memory(unit); }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.62.0-alpha.0" };
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.62.0-alpha.0" };
/**
 * CORRETTO 8
 */
Runtime.CORRETTO_8 = Runtime.of('CORRETTO_8');
/**
 * CORRETTO 11
 */
Runtime.CORRETTO_11 = Runtime.of('CORRETTO_11');
/**
 * .NET 6
 */
Runtime.DOTNET_6 = Runtime.of('DOTNET_6');
/**
 * Go 1.18
 */
Runtime.GO_1 = Runtime.of('GO_1');
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * NodeJS 14
 */
Runtime.NODEJS_14 = Runtime.of('NODEJS_14');
/**
 * NodeJS 16
 */
Runtime.NODEJS_16 = Runtime.of('NODEJS_16');
/**
 * PHP 8.1
 */
Runtime.PHP_81 = Runtime.of('PHP_81');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Ruby 3.1
 */
Runtime.RUBY_31 = Runtime.of('RUBY_31');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.62.0-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.62.0-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.62.0-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.62.0-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.62.0-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType = exports.ConfigurationSourceType || (exports.ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    constructor(arn) {
        this.connectionArn = arn;
    }
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.62.0-alpha.0" };
/**
 * A secret environment variable.
 */
class Secret {
    /**
     * Creates an environment variable value from a parameter stored in AWS
     * Systems Manager Parameter Store.
     */
    static fromSsmParameter(parameter) {
        return {
            arn: parameter.parameterArn,
            grantRead: grantee => parameter.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManager(secret, field) {
        return {
            arn: field ? `${secret.secretArn}:${field}::` : secret.secretArn,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param versionInfo the version information to reference the secret
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManagerVersion(secret, versionInfo, field) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_SecretVersionInfo(versionInfo);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManagerVersion);
            }
            throw error;
        }
        return {
            arn: `${secret.secretArn}:${field ?? ''}:${versionInfo.versionStage ?? ''}:${versionInfo.versionId ?? ''}`,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
}
exports.Secret = Secret;
_k = JSII_RTTI_SYMBOL_1;
Secret[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.Secret", version: "2.62.0-alpha.0" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service.
         *
         * @deprecated use environmentVariables.
         */
        this.environment = {};
        /**
         * Environment variables for this service.
         */
        this.environmentVariables = {};
        /**
         * Environment secrets for this service.
         */
        this.environmentSecrets = {};
        /**
         * Environment secrets for this service.
         */
        this.secrets = [];
        /**
         * Environment variables for this service.
         */
        this.variables = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        this.environmentVariables = this.getEnvironmentVariables();
        this.environmentSecrets = this.getEnvironmentSecrets();
        // generate an IAM role only when ImageRepositoryType is ECR and props.accessRole is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ?? this.generateDefaultRole() : undefined;
        // generalte an IAM role only when environmentSecrets has values and props.instanceRole is undefined
        this.instanceRole = (Object.keys(this.environmentSecrets).length > 0 && !this.props.instanceRole) ?
            this.createInstanceRole() : this.props.instanceRole;
        if (this.source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            this.source.codeRepository?.codeConfiguration.configurationValues) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            instanceConfiguration: {
                cpu: this.props.cpu?.unit,
                memory: this.props.memory?.unit,
                instanceRoleArn: this.instanceRole?.roleArn,
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                imageRepository: this.source.imageRepository ?
                    this.renderImageRepository(this.source.imageRepository) :
                    undefined,
                codeRepository: this.source.codeRepository ?
                    this.renderCodeConfiguration(this.source.codeRepository.codeConfiguration.configurationValues) :
                    undefined,
            },
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
            },
        });
        // grant required privileges for the role
        if (this.source.ecrRepository && this.accessRole) {
            this.source.ecrRepository.grantPull(this.accessRole);
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        this.serviceName = resource.ref;
    }
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    /**
     * This method adds an environment variable to the App Runner service.
     */
    addEnvironmentVariable(name, value) {
        this.variables.push({ name: name, value: value });
    }
    /**
     * This method adds a secret as environment variable to the App Runner service.
     */
    addSecret(name, secret) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_Secret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addSecret);
            }
            throw error;
        }
        if (!this.instanceRole) {
            this.instanceRole = this.createInstanceRole();
        }
        secret.grantRead(this.instanceRole);
        this.secrets.push({ name: name, value: secret.arn });
    }
    /**
     * This method generates an Instance Role. Needed if using secrets and props.instanceRole is undefined
     * @returns iam.IRole
     */
    createInstanceRole() {
        return new iam.Role(this, 'InstanceRole', {
            assumedBy: new iam.ServicePrincipal('tasks.apprunner.amazonaws.com'),
            roleName: cdk.PhysicalName.GENERATE_IF_NEEDED,
        });
    }
    /**
     * This method generates an Access Role only when ImageRepositoryType is ECR and props.accessRole is undefined
     * @returns iam.IRole
     */
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
    getEnvironmentSecrets() {
        let secrets = this.source.codeRepository?.codeConfiguration.configurationValues?.environmentSecrets ??
            this.source.imageRepository?.imageConfiguration?.environmentSecrets;
        return secrets || {};
    }
    getEnvironmentVariables() {
        let codeEnv = [
            this.source.codeRepository?.codeConfiguration.configurationValues?.environmentVariables,
            this.source.codeRepository?.codeConfiguration.configurationValues?.environment,
        ];
        let imageEnv = [
            this.source.imageRepository?.imageConfiguration?.environmentVariables,
            this.source.imageRepository?.imageConfiguration?.environment,
        ];
        if (codeEnv.every(el => el !== undefined) || imageEnv.every(el => el !== undefined)) {
            throw new Error([
                'You cannot set both \'environmentVariables\' and \'environment\' properties.',
                'Please only use environmentVariables, as environment is deprecated.',
            ].join(' '));
        }
        return codeEnv.find(el => el !== undefined) || imageEnv.find(el => el !== undefined) || {};
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration(props) {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(props) :
                    undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
            runtimeEnvironmentSecrets: this.renderEnvironmentSecrets(),
            startCommand: props.startCommand,
        };
    }
    renderEnvironmentVariables() {
        if (Object.keys(this.environmentVariables).length > 0) {
            for (const [key, value] of Object.entries(this.environmentVariables)) {
                if (key.startsWith('AWSAPPRUNNER')) {
                    throw new Error(`Environment variable key ${key} with a prefix of AWSAPPRUNNER is not allowed`);
                }
                this.variables.push({ name: key, value: value });
            }
            return this.variables;
        }
        else {
            return undefined;
        }
    }
    renderEnvironmentSecrets() {
        if (Object.keys(this.environmentSecrets).length > 0 && this.instanceRole) {
            for (const [key, value] of Object.entries(this.environmentSecrets)) {
                if (key.startsWith('AWSAPPRUNNER')) {
                    throw new Error(`Environment secret key ${key} with a prefix of AWSAPPRUNNER is not allowed`);
                }
                value.grantRead(this.instanceRole);
                this.secrets.push({ name: key, value: value.arn });
            }
            return this.secrets;
        }
        else {
            return undefined;
        }
    }
    renderImageRepository(repo) {
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: this.renderEnvironmentVariables(),
                runtimeEnvironmentSecrets: this.renderEnvironmentSecrets(),
            },
        });
    }
}
exports.Service = Service;
_l = JSII_RTTI_SYMBOL_1;
Service[_l] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.62.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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