# AUTOGENERATED! DO NOT EDIT! File to edit: 03_functions.ipynb (unless otherwise specified).

__all__ = ['STOPWORDS', 'normalize', 'split_by_newline', 'rm_useless_spaces', 'make_sentences', 'write_to_file_cleaned',
           'clean', 'get_wordnet_pos', 'remove_stopwords', 'remove_punctuations', 'remove_punc_clean', 'process']

# Cell
import nltk

# Cell
#export
nltk.download('punkt')
nltk.download('stopwords')
nltk.download('averaged_perceptron_tagger')
nltk.download('wordnet')

# Cell
import os
import pandas as pd
import pickle
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
from sklearn.metrics.pairwise import cosine_similarity
from nltk.tokenize import sent_tokenize
from nltk.tokenize import word_tokenize
from nltk.corpus import wordnet, stopwords
import unidecode
import re
from nltk.stem import WordNetLemmatizer
STOPWORDS = set(stopwords.words('english'))

# Cell
def normalize(data):
    """
    The function takes an array, matrix as input and normalizes
    it between 0 and 1

    Args:
        data (ndarray): any 1-D, or 2-D numpy array

    Returns:
        (ndarray): normalized ndarray
    """
    return (data - np.min(data)) / (np.max(data) - np.min(data))

# Cell
def split_by_newline(all):
    """
    Only use when sentences are already tokenized
    returns sentences split by '\\n' if len(line) > 0

    Args:
        all (str): tokenized string to be split by '\\n'

    Returns:
        list: list of sentences split by '\\n'
    """
    return [line.lower() for line in all.split('\n') if len(line) > 0]

# Cell
def rm_useless_spaces(t):
    "Remove multiple spaces"
    _re_space = re.compile(' {2,}')
    return _re_space.sub(' ', t)

# Cell
def make_sentences(all):
    all_cleaned = all.replace('\n',' ')
    all_cleaned = rm_useless_spaces(all_cleaned)
    all_cleaned = all_cleaned.strip()
    all_cleaned = unidecode.unidecode(all_cleaned)
    sentences = sent_tokenize(all_cleaned)
    return sentences

# Cell
def write_to_file_cleaned(sentences, fname):
    with open(fname[:-4]+'_cleaned.txt', 'w') as f:
        for line in sentences:
            f.write(line + '\n')
    f.close()

# Cell
def clean(fname):
    all = get_data(fname)
    sentences = make_sentences(all)
    print(fname[:-4].title() + ' contains {} sentences'.format(len(sentences)))
    write_to_file_cleaned(sentences, fname)

# Cell
def get_wordnet_pos(word):
    """Map POS tag to first character lemmatize() accepts"""
    tag = nltk.pos_tag([word])[0][1][0].upper()
    tag_dict = {"J": wordnet.ADJ,
                "N": wordnet.NOUN,
                "V": wordnet.VERB,
                "R": wordnet.ADV}

    return tag_dict.get(tag, wordnet.NOUN)

# Cell
def remove_stopwords(sentence):
    sentences = []
    for word in sentence.split():
        if word.lower() not in STOPWORDS:
            sentences.append(word)
    return ' '.join(sentences)

# Cell
def remove_punctuations(sentence):
    pat2 = re.compile('[^a-zA-Z0-9 ]+')
    pat1 = re.compile('[\s]+')

    doc = pat2.sub(' ', sentence)
    doc = pat1.sub(' ', doc)
    doc = doc.strip()
    return doc

# Cell
def remove_punc_clean(sentence):
    doc = remove_punctuations(sentence)
    doc = remove_stopwords(doc)
    # doc = ' '.join(list(OrderedDict.fromkeys(doc.split())))

    lemmatizer = WordNetLemmatizer()
    doc = ' '.join([lemmatizer.lemmatize(w, get_wordnet_pos(w)) for w in doc.split()])
    return doc

# Cell
def process(fname):
    all_data = get_data(fname)
    all_data = unidecode.unidecode(all_data)
    sentences = make_sentences(all_data)
    clean_sentences = []
    removed_sentences = []
    for i, sentence in enumerate(sentences):
        t = remove_punc_clean(sentence)
        if len(t) > 0:
            clean_sentences.append(t)
        else:
            removed_sentences.append(i)

    # write_to_file_lexical(clean_sentences, fname)
    print('Done processing', fname)
    return removed_sentences