"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsEventSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * Use an Amazon SQS queue as an event source for AWS Lambda.
 */
class SqsEventSource {
    constructor(queue, props = {}) {
        this.queue = queue;
        this.props = props;
        this._eventSourceMappingId = undefined;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_event_sources_SqsEventSourceProps(props);
        if (this.props.maxBatchingWindow !== undefined) {
            if (queue.fifo) {
                throw new Error('Batching window is not supported for FIFO queues');
            }
            if (!this.props.maxBatchingWindow.isUnresolved() && this.props.maxBatchingWindow.toSeconds() > 300) {
                throw new Error(`Maximum batching window must be 300 seconds or less (given ${this.props.maxBatchingWindow.toHumanString()})`);
            }
        }
        if (this.props.batchSize !== undefined && !core_1.Token.isUnresolved(this.props.batchSize)) {
            if (this.props.maxBatchingWindow !== undefined && (this.props.batchSize < 1 || this.props.batchSize > 10000)) {
                throw new Error(`Maximum batch size must be between 1 and 10000 inclusive (given ${this.props.batchSize}) when batching window is specified.`);
            }
            if (this.props.maxBatchingWindow === undefined && (this.props.batchSize < 1 || this.props.batchSize > 10)) {
                throw new Error(`Maximum batch size must be between 1 and 10 inclusive (given ${this.props.batchSize}) when batching window is not specified.`);
            }
        }
    }
    bind(target) {
        const eventSourceMapping = target.addEventSourceMapping(`SqsEventSource:${core_1.Names.nodeUniqueId(this.queue.node)}`, {
            batchSize: this.props.batchSize,
            maxBatchingWindow: this.props.maxBatchingWindow,
            reportBatchItemFailures: this.props.reportBatchItemFailures,
            enabled: this.props.enabled,
            eventSourceArn: this.queue.queueArn,
        });
        this._eventSourceMappingId = eventSourceMapping.eventSourceMappingId;
        this.queue.grantConsumeMessages(target);
    }
    /**
     * The identifier for this EventSourceMapping
     */
    get eventSourceMappingId() {
        if (!this._eventSourceMappingId) {
            throw new Error('SqsEventSource is not yet bound to an event source mapping');
        }
        return this._eventSourceMappingId;
    }
}
exports.SqsEventSource = SqsEventSource;
_a = JSII_RTTI_SYMBOL_1;
SqsEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SqsEventSource", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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