"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * All known Lambda runtime families.
 */
var RuntimeFamily;
(function (RuntimeFamily) {
    /**
     * All Lambda runtimes that depend on Node.js.
     */
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    /**
     * All lambda runtimes that depend on Python.
     */
    RuntimeFamily[RuntimeFamily["PYTHON"] = 1] = "PYTHON";
    /**
     * Any future runtime family.
     */
    RuntimeFamily[RuntimeFamily["OTHER"] = 2] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Runtime options for a canary
 */
class Runtime {
    /**
      * @param name The name of the runtime version
      * @param family The Lambda runtime family
      */
    constructor(name, family) {
        this.name = name;
        this.family = family;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_synthetics_RuntimeFamily(family);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-synthetics.Runtime", version: "1.153.1" };
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-1.0` includes the following:
 *
 * - Synthetics library 1.0
 * - Synthetics handler code 1.0
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 1.14.0
 * - The Chromium version that matches Puppeteer-core 1.14.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0
 */
Runtime.SYNTHETICS_1_0 = new Runtime('syn-1.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.0` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0
 */
Runtime.SYNTHETICS_NODEJS_2_0 = new Runtime('syn-nodejs-2.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.1` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1
 */
Runtime.SYNTHETICS_NODEJS_2_1 = new Runtime('syn-nodejs-2.1', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.2` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2
 */
Runtime.SYNTHETICS_NODEJS_2_2 = new Runtime('syn-nodejs-2.2', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.0` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_0 = new Runtime('syn-nodejs-puppeteer-3.0', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.1` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_1 = new Runtime('syn-nodejs-puppeteer-3.1', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.2` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_2 = new Runtime('syn-nodejs-puppeteer-3.2', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.3` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_3 = new Runtime('syn-nodejs-puppeteer-3.3', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.4` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_4 = new Runtime('syn-nodejs-puppeteer-3.4', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.5` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_5 = new Runtime('syn-nodejs-puppeteer-3.5', RuntimeFamily.NODEJS);
/**
 * `syn-python-selenium-1.0` includes the following:
 * - Lambda runtime Python 3.8
 * - Selenium version 3.141.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html
 */
Runtime.SYNTHETICS_PYTHON_SELENIUM_1_0 = new Runtime('syn-python-selenium-1.0', RuntimeFamily.PYTHON);
//# sourceMappingURL=data:application/json;base64,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