/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext.transform;

import com.github.weisj.darklaf.log.LogFormatter;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.pbjar.jxlayer.plaf.ext.TransformUI;

public final class TransformRPMImpl {
    private static final Logger LOGGER = Logger.getLogger(TransformRPMImpl.class.getName());
    public static boolean hack = false;

    private TransformRPMImpl() {
    }

    public static boolean addDirtyRegion(JComponent aComponent, int x, int y, int w, int h, RepaintManager manager) {
        JXLayer<?> layer;
        if (aComponent.isShowing() && (layer = TransformRPMImpl.findJXLayer(aComponent)) != null) {
            LayerUI<?> layerUI = layer.getUI();
            TransformUI ui = (TransformUI)layerUI;
            Point point = aComponent.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(point, layer);
            Rectangle transformPortRegion = ui.transform(new Rectangle(x + point.x, y + point.y, w, h), layer);
            manager.addDirtyRegion(layer, transformPortRegion.x, transformPortRegion.y, transformPortRegion.width, transformPortRegion.height);
            return true;
        }
        return false;
    }

    public static void hackInitialization(RepaintManager sourceManager, RepaintManager destinationManager) {
        if (hack) {
            Class<RepaintManager> rpmClass = RepaintManager.class;
            try {
                Field fieldBufferStrategyType = rpmClass.getDeclaredField("bufferStrategyType");
                Field fieldPaintManager = rpmClass.getDeclaredField("paintManager");
                Method methodGetPaintManager = rpmClass.getDeclaredMethod("getPaintManager", new Class[0]);
                fieldBufferStrategyType.setAccessible(true);
                fieldPaintManager.setAccessible(true);
                methodGetPaintManager.setAccessible(true);
                Object paintManager = methodGetPaintManager.invoke((Object)sourceManager, new Object[0]);
                short bufferStrategyType = (Short)fieldBufferStrategyType.get(sourceManager);
                fieldBufferStrategyType.set(destinationManager, bufferStrategyType);
                fieldPaintManager.set(destinationManager, paintManager);
                fieldBufferStrategyType.setAccessible(false);
                fieldPaintManager.setAccessible(false);
                methodGetPaintManager.setAccessible(false);
                LOGGER.warning("Copied paintManager of type: " + paintManager.getClass().getName());
                switch (bufferStrategyType) {
                    case 0: {
                        LOGGER.warning("Copied bufferStrategyType " + bufferStrategyType + ": BUFFER_STRATEGY_NOT_SPECIFIED");
                        break;
                    }
                    case 1: {
                        LOGGER.warning("Copied bufferStrategyType " + bufferStrategyType + ": BUFFER_STRATEGY_SPECIFIED_ON");
                        break;
                    }
                    case 2: {
                        LOGGER.warning("Copied bufferStrategyType " + bufferStrategyType + ": BUFFER_STRATEGY_SPECIFIED_OFF");
                        break;
                    }
                    default: {
                        LOGGER.warning("Copied bufferStrategyType " + bufferStrategyType + ": ???");
                        break;
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.getMessage(), t.getStackTrace());
            }
        }
    }

    private static JXLayer<?> findJXLayer(JComponent aComponent) {
        JXLayer layer = (JXLayer)SwingUtilities.getAncestorOfClass(JXLayer.class, aComponent);
        if (layer != null) {
            LayerUI ui = layer.getUI();
            if (ui instanceof TransformUI) {
                return layer;
            }
            return TransformRPMImpl.findJXLayer(layer);
        }
        return null;
    }

    static {
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter());
        LOGGER.addHandler(handler);
    }
}

