/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext.transform;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.jxlayer.JXLayer;
import org.pbjar.jxlayer.plaf.ext.transform.TransformModel;

public class DefaultTransformModel
implements TransformModel {
    private final Map<ChangeListener, Object> listeners = new WeakHashMap<ChangeListener, Object>();
    private final AffineTransform transform = new AffineTransform();
    private final Object[] values = Type.createArray();
    private final Object[] prevValues = Type.createArray();
    private Point2D rotationCenter;
    private Function<Dimension, Point2D> supplier;
    private boolean valid = false;

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.put(listener, null);
    }

    @Override
    public AffineTransform getPreferredTransform(Dimension size, JXLayer<?> layer) {
        Point2D p = this.getRotationCenter(size);
        double centerX = p.getX();
        double centerY = p.getY();
        AffineTransform transform = this.transformNoScale(centerX, centerY);
        double scaleX = (Double)this.getValue(Type.PreferredScale);
        transform.translate(centerX, centerY);
        transform.scale((Boolean)this.getValue(Type.Mirror) != false ? -scaleX : scaleX, scaleX);
        transform.translate(-centerX, -centerY);
        return transform;
    }

    public Point2D getRotationCenter(Dimension size) {
        if (this.supplier != null) {
            return this.supplier.apply(size);
        }
        double centerX = size == null ? 0.0 : size.getWidth() / 2.0;
        double centerY = size == null ? 0.0 : size.getHeight() / 2.0;
        return this.rotationCenter == null ? new Point2D.Double(centerX, centerY) : this.rotationCenter;
    }

    protected AffineTransform transformNoScale(double centerX, double centerY) {
        AffineTransform at = new AffineTransform();
        at.translate(centerX, centerY);
        at.rotate(this.getRotation());
        at.quadrantRotate(this.getQuadrantRotation());
        at.shear(this.getShearX(), this.getShearY());
        at.translate(-centerX, -centerY);
        return at;
    }

    public double getRotation() {
        return (Double)this.getValue(Type.Rotation);
    }

    protected <T> T getValue(Type type) {
        return (T)this.values[type.ordinal()];
    }

    public int getQuadrantRotation() {
        return (Integer)this.getValue(Type.QuadrantRotation);
    }

    public void setQuadrantRotation(int newValue) {
        this.setValue(Type.QuadrantRotation, newValue);
    }

    public void setScale(double newValue) throws IllegalArgumentException {
        if (newValue == 0.0) {
            throw new IllegalArgumentException("Preferred scale can not be set to 0");
        }
        this.setValue(Type.PreferredScale, newValue);
    }

    @Override
    public AffineTransform getTransform(JXLayer<? extends JComponent> layer) {
        JComponent view = layer == null ? null : layer.getView();
        this.setValue(Type.LayerWidth, layer == null ? 0 : layer.getWidth());
        this.setValue(Type.LayerHeight, layer == null ? 0 : layer.getHeight());
        this.setValue(Type.ViewWidth, view == null ? 0 : view.getWidth());
        this.setValue(Type.ViewHeight, view == null ? 0 : view.getHeight());
        if (!Arrays.equals(this.prevValues, this.values) || !this.valid) {
            System.arraycopy(this.values, 0, this.prevValues, 0, this.values.length);
            this.transform.setToIdentity();
            if (view != null) {
                double scaleY;
                double scaleX;
                Point2D p = this.getRotationCenter(layer == null ? null : layer.getSize());
                double centerX = p.getX();
                double centerY = p.getY();
                AffineTransform nonScaledTransform = this.transformNoScale(centerX, centerY);
                if (((Boolean)this.getValue(Type.ScaleToPreferredSize)).booleanValue()) {
                    scaleY = scaleX = ((Double)this.getValue(Type.PreferredScale)).doubleValue();
                } else {
                    Area area = new Area(new Rectangle2D.Double(0.0, 0.0, view.getWidth(), view.getHeight()));
                    area.transform(nonScaledTransform);
                    Rectangle2D bounds = area.getBounds2D();
                    scaleX = layer == null ? 0.0 : (double)layer.getWidth() / bounds.getWidth();
                    double d = scaleY = layer == null ? 0.0 : (double)layer.getHeight() / bounds.getHeight();
                    if (((Boolean)this.getValue(Type.PreserveAspectRatio)).booleanValue()) {
                        scaleY = scaleX = Math.min(scaleX, scaleY);
                    }
                }
                this.transform.translate(centerX, centerY);
                this.transform.scale((Boolean)this.getValue(Type.Mirror) != false ? -scaleX : scaleX, scaleY);
                this.transform.translate(-centerX, -centerY);
                this.transform.concatenate(nonScaledTransform);
            }
        }
        this.valid = true;
        return this.transform;
    }

    public double getShearX() {
        return (Double)this.getValue(Type.ShearX);
    }

    public void setShearX(double newValue) {
        this.setValue(Type.ShearX, newValue);
    }

    public double getShearY() {
        return (Double)this.getValue(Type.ShearY);
    }

    public void setShearY(double newValue) {
        this.setValue(Type.ShearY, newValue);
    }

    public void setRotation(double newValue) {
        this.setValue(Type.Rotation, newValue);
    }

    private void setValue(Type type, Object newValue) {
        Object oldValue = this.values[type.ordinal()];
        this.values[type.ordinal()] = newValue;
        this.fireChangeEvent(oldValue, newValue);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public double getScale() {
        return (Double)this.getValue(Type.PreferredScale);
    }

    protected void fireChangeEvent(Object oldValue, Object newValue) {
        if (!oldValue.equals(newValue)) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners.keySet()) {
                listener.stateChanged(event);
            }
        }
    }

    public void setRotationCenter(Point2D rotationCenter) {
        this.rotationCenter = rotationCenter;
    }

    public boolean isMirror() {
        return (Boolean)this.getValue(Type.Mirror);
    }

    public void setMirror(boolean newValue) {
        this.setValue(Type.Mirror, newValue);
    }

    public boolean isPreserveAspectRatio() {
        return (Boolean)this.getValue(Type.PreserveAspectRatio);
    }

    public void setPreserveAspectRatio(boolean newValue) {
        this.setValue(Type.PreserveAspectRatio, newValue);
    }

    public boolean isScaleToPreferredSize() {
        return (Boolean)this.getValue(Type.ScaleToPreferredSize);
    }

    public void setScaleToPreferredSize(boolean newValue) {
        this.setValue(Type.ScaleToPreferredSize, newValue);
    }

    public void setRotationCenterSupplier(Function<Dimension, Point2D> supplier) {
        this.supplier = supplier;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected static enum Type {
        LayerWidth(0),
        LayerHeight(0),
        ViewWidth(0),
        ViewHeight(0),
        PreferredScale(1.0),
        Rotation(0.0),
        ShearX(0.0),
        ShearY(0.0),
        QuadrantRotation(0),
        PreserveAspectRatio(Boolean.TRUE),
        ScaleToPreferredSize(Boolean.FALSE),
        Mirror(Boolean.FALSE);

        private final Object defaultValue;

        private Type(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public static Object[] createArray() {
            Object[] array = new Object[Type.values().length];
            for (Type type : Type.values()) {
                array[type.ordinal()] = type.defaultValue;
            }
            return array;
        }
    }
}

