/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext;

import com.github.weisj.darklaf.log.LogFormatter;
import com.sun.java.swing.SwingUtilities3;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.ForwardingRepaintManager;
import org.pbjar.jxlayer.plaf.ext.MouseEventUI;
import org.pbjar.jxlayer.plaf.ext.transform.DefaultTransformModel;
import org.pbjar.jxlayer.plaf.ext.transform.TransformLayout;
import org.pbjar.jxlayer.plaf.ext.transform.TransformModel;
import org.pbjar.jxlayer.plaf.ext.transform.TransformRPMAnnotation;
import org.pbjar.jxlayer.plaf.ext.transform.TransformRPMFallBack;
import org.pbjar.jxlayer.plaf.ext.transform.TransformRPMSwingX;
import org.pbjar.jxlayer.repaint.RepaintManagerProvider;
import org.pbjar.jxlayer.repaint.RepaintManagerUtils;
import org.pbjar.jxlayer.repaint.WrappedRepaintManager;

public class TransformUI
extends MouseEventUI<JComponent> {
    private static final LayoutManager transformLayout;
    private static final String KEY_VIEW = "view";
    private static final boolean delegatePossible;
    private static final RepaintManager wrappedManager;
    private static final Logger LOGGER;
    private final ChangeListener changeListener = e -> this.revalidateLayer();
    private final RepaintManagerProvider rpmProvider = new RepaintManagerProvider(){

        @Override
        public Class<? extends ForwardingRepaintManager> getForwardingRepaintManagerClass() {
            return TransformRPMSwingX.class;
        }

        @Override
        public Class<? extends WrappedRepaintManager> getWrappedRepaintManagerClass() {
            return TransformRPMFallBack.class;
        }

        @Override
        public boolean isAdequate(Class<? extends RepaintManager> manager) {
            return manager.isAnnotationPresent(TransformRPMAnnotation.class);
        }
    };
    private final Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    private final Set<JComponent> originalDoubleBuffered = new HashSet<JComponent>();
    private JComponent view;
    private final PropertyChangeListener viewChangeListener = evt -> this.setView((JComponent)evt.getNewValue());
    private TransformModel transformModel;
    private LayoutManager originalLayout;

    public TransformUI() {
        this(new DefaultTransformModel());
    }

    public TransformUI(TransformModel model) {
        this.setModel(model);
    }

    private void revalidateLayer() {
        JXLayer installedLayer = this.getInstalledLayer();
        if (installedLayer != null) {
            installedLayer.revalidate();
            installedLayer.repaint();
        }
    }

    public static void prepareForJTextComponent() {
        System.setProperty("i18n", Boolean.TRUE.toString());
    }

    public void addRenderingHint(RenderingHints.Key key, Object value) {
        this.renderingHints.put(key, value);
    }

    public void addRenderingHints(Map<RenderingHints.Key, Object> hints) {
        this.renderingHints.putAll(hints);
    }

    public final TransformModel getModel() {
        return this.transformModel;
    }

    public final void setModel(TransformModel transformModel) throws NullPointerException {
        if (transformModel == null) {
            throw new NullPointerException("The TransformModel may not be null");
        }
        if (this.transformModel != null) {
            this.transformModel.removeChangeListener(this.changeListener);
        }
        this.transformModel = transformModel;
        this.transformModel.addChangeListener(this.changeListener);
        this.revalidateLayer();
    }

    public AffineTransform getPreferredTransform(Dimension size, JXLayer<? extends JComponent> layer) {
        return this.transformModel != null ? this.transformModel.getPreferredTransform(size, layer) : new AffineTransform();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        JXLayer installedLayer = this.getInstalledLayer();
        this.originalLayout = installedLayer.getLayout();
        installedLayer.addPropertyChangeListener(KEY_VIEW, this.viewChangeListener);
        installedLayer.setLayout(transformLayout);
        this.setView((JComponent)installedLayer.getView());
        if (!delegatePossible) {
            RepaintManagerUtils.ensureRepaintManagerSet(installedLayer, this.rpmProvider);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        JXLayer installedLayer = this.getInstalledLayer();
        Objects.requireNonNull(installedLayer).removePropertyChangeListener(KEY_VIEW, this.viewChangeListener);
        installedLayer.setLayout(this.originalLayout);
        this.setView(null);
        super.uninstallUI(c);
    }

    private void setView(JComponent view) {
        if (delegatePossible && this.view != null) {
            SwingUtilities3.setDelegateRepaintManager(this.view, null);
        }
        this.view = view;
        if (delegatePossible && this.view != null) {
            SwingUtilities3.setDelegateRepaintManager(this.view, wrappedManager);
        }
        this.setDirty(true);
    }

    public void setRenderingHints(Map<RenderingHints.Key, Object> hints) {
        this.renderingHints.clear();
        if (hints != null) {
            this.renderingHints.putAll(hints);
        }
    }

    public final Rectangle transform(Rectangle rect, JXLayer<? extends JComponent> layer) {
        AffineTransform at = this.getTransform(layer);
        if (at == null) {
            return rect;
        }
        Area area = new Area(rect);
        area.transform(at);
        return area.getBounds();
    }

    @Override
    public void updateUI(JXLayer<? extends JComponent> layer) {
        this.setDirty(true);
    }

    private Color getBackgroundColor(JXLayer<? extends JComponent> layer) {
        Container colorProvider;
        Container container = colorProvider = layer.getView() == null ? layer : (Container)layer.getView();
        while (colorProvider != null && !((Component)colorProvider).isOpaque()) {
            colorProvider = colorProvider.getParent();
        }
        return colorProvider == null ? SystemColor.desktop : colorProvider.getBackground();
    }

    private void setToNoDoubleBuffering(Component component) {
        JComponent comp;
        if (component instanceof JComponent && (comp = (JComponent)component).isDoubleBuffered()) {
            this.originalDoubleBuffered.add(comp);
            comp.setDoubleBuffered(false);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int index = 0; index < container.getComponentCount(); ++index) {
                this.setToNoDoubleBuffering(container.getComponent(index));
            }
        }
    }

    @Override
    protected final void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> layer) {
        JComponent view = layer.getView();
        if (view != null && (view.getX() < 0 || view.getY() < 0)) {
            this.setToNoDoubleBuffering(view);
            g2.translate(view.getX(), view.getY());
            view.paint(g2);
            for (JComponent comp : this.originalDoubleBuffered) {
                comp.setDoubleBuffered(true);
            }
            this.originalDoubleBuffered.clear();
            return;
        }
        super.paintLayer(g2, layer);
    }

    @Override
    protected final AffineTransform getTransform(JXLayer<? extends JComponent> layer) {
        return this.transformModel != null ? this.transformModel.getTransform(layer) : new AffineTransform();
    }

    @Override
    protected Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<? extends JComponent> layer) {
        return this.renderingHints;
    }

    static {
        boolean value;
        transformLayout = new TransformLayout();
        wrappedManager = new TransformRepaintManager();
        LOGGER = Logger.getLogger(TransformUI.class.getName());
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter());
        LOGGER.addHandler(handler);
        try {
            SwingUtilities3.class.getMethod("setDelegateRepaintManager", JComponent.class, RepaintManager.class);
            value = true;
        }
        catch (Throwable t) {
            value = false;
        }
        delegatePossible = value;
        LOGGER.info("Java " + System.getProperty("java.version") + " " + System.getProperty("java.vm.version") + (delegatePossible ? ": RepaintManager delegate facility for JavaFX will be used." : ": RepaintManager.setCurrentManager() will be used."));
    }

    protected static final class TransformRepaintManager
    extends RepaintManager {
        private TransformRepaintManager() {
        }

        @Override
        public void addInvalidComponent(JComponent invalidComponent) {
            JXLayer<? extends JComponent> layer = this.findJXLayer(invalidComponent);
            RepaintManager.currentManager(layer).addInvalidComponent(layer);
        }

        @Override
        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            if (c.isShowing()) {
                JXLayer<? extends JComponent> layer = this.findJXLayer(c);
                TransformUI ui = (TransformUI)layer.getUI();
                Point point = c.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, layer);
                Rectangle transformPortRegion = ui.transform(new Rectangle(x + point.x, y + point.y, w, h), layer);
                RepaintManager.currentManager(layer).addDirtyRegion(layer, transformPortRegion.x, transformPortRegion.y, transformPortRegion.width, transformPortRegion.height);
            }
        }

        private JXLayer<? extends JComponent> findJXLayer(JComponent c) {
            JXLayer layer = (JXLayer)SwingUtilities.getAncestorOfClass(JXLayer.class, c);
            if (layer != null) {
                LayerUI layerUI = layer.getUI();
                if (layerUI instanceof TransformUI) {
                    return layer;
                }
                return this.findJXLayer(layer);
            }
            throw new Error("No parent JXLayer with TransformUI found");
        }
    }
}

