/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.mult;

import java.util.Arrays;
import org.ejml.data.DMatrixSparseCSC;

public class MatrixVectorMult_DSCC {
    public static void mult(DMatrixSparseCSC A2, double[] b, int offsetB, double[] c, int offsetC) {
        Arrays.fill(c, offsetC, offsetC + A2.numRows, 0.0);
        MatrixVectorMult_DSCC.multAdd(A2, b, offsetB, c, offsetC);
    }

    public static void multAdd(DMatrixSparseCSC A2, double[] b, int offsetB, double[] c, int offsetC) {
        if (b.length - offsetB < A2.numCols) {
            throw new IllegalArgumentException("Length of 'b' isn't long enough");
        }
        if (c.length - offsetC < A2.numRows) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        for (int k = 0; k < A2.numCols; ++k) {
            int idx0 = A2.col_idx[k];
            int idx1 = A2.col_idx[k + 1];
            for (int indexA = idx0; indexA < idx1; ++indexA) {
                int n = offsetC + A2.nz_rows[indexA];
                c[n] = c[n] + A2.nz_values[indexA] * b[offsetB + k];
            }
        }
    }

    public static void mult(double[] a, int offsetA, DMatrixSparseCSC B, double[] c, int offsetC) {
        if (a.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Length of 'a' isn't long enough");
        }
        if (c.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        for (int k = 0; k < B.numCols; ++k) {
            int idx0 = B.col_idx[k];
            int idx1 = B.col_idx[k + 1];
            double sum = 0.0;
            for (int indexB = idx0; indexB < idx1; ++indexB) {
                sum += a[offsetA + B.nz_rows[indexB]] * B.nz_values[indexB];
            }
            c[offsetC + k] = sum;
        }
    }

    public static double innerProduct(double[] a, int offsetA, DMatrixSparseCSC B, double[] c, int offsetC) {
        if (a.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Length of 'a' isn't long enough");
        }
        if (c.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        double output = 0.0;
        for (int k = 0; k < B.numCols; ++k) {
            int idx0 = B.col_idx[k];
            int idx1 = B.col_idx[k + 1];
            double sum = 0.0;
            for (int indexB = idx0; indexB < idx1; ++indexB) {
                sum += a[offsetA + B.nz_rows[indexB]] * B.nz_values[indexB];
            }
            output += sum * c[offsetC + k];
        }
        return output;
    }
}

