/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.sparse.csc.misc.ImplCommonOps_MT_DSCC;
import org.ejml.sparse.csc.mult.ImplMultiplication_MT_DSCC;
import org.ejml.sparse.csc.mult.Workspace_MT_DSCC;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class CommonOps_MT_DSCC {
    public static DMatrixSparseCSC mult(DMatrixSparseCSC A2, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC outputC) {
        return CommonOps_MT_DSCC.mult(A2, B, outputC, null);
    }

    public static DMatrixSparseCSC mult(DMatrixSparseCSC A2, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC outputC, @Nullable GrowArray<Workspace_MT_DSCC> listWork) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2, A2.numRows, B.numCols);
        if (listWork == null) {
            listWork = new GrowArray<Workspace_MT_DSCC>(Workspace_MT_DSCC::new);
        }
        ImplMultiplication_MT_DSCC.mult(A2, B, outputC, listWork);
        return outputC;
    }

    public static DMatrixSparseCSC add(double alpha, DMatrixSparseCSC A2, double beta, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC outputC, @Nullable GrowArray<Workspace_MT_DSCC> listWork) {
        if (A2.numRows != B.numRows || A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2, A2.numRows, A2.numCols);
        if (listWork == null) {
            listWork = new GrowArray<Workspace_MT_DSCC>(Workspace_MT_DSCC::new);
        }
        ImplCommonOps_MT_DSCC.add(alpha, A2, beta, B, outputC, listWork);
        return outputC;
    }

    public static DMatrixRMaj mult(DMatrixSparseCSC A2, DMatrixRMaj B, @Nullable DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workArrays) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numRows, B.numCols);
        if (workArrays == null) {
            workArrays = new GrowArray<DGrowArray>(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.mult(A2, B, outputC, workArrays);
        return outputC;
    }

    public static void multAdd(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workArrays) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numRows != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (workArrays == null) {
            workArrays = new GrowArray<DGrowArray>(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multAdd(A2, B, outputC, workArrays);
    }

    public static DMatrixRMaj multTransA(DMatrixSparseCSC A2, DMatrixRMaj B, @Nullable DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workArray) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numCols, B.numCols);
        if (workArray == null) {
            workArray = new GrowArray<DGrowArray>(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multTransA(A2, B, outputC, workArray);
        return outputC;
    }

    public static void multAddTransA(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workArray) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numCols != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (workArray == null) {
            workArray = new GrowArray<DGrowArray>(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multAddTransA(A2, B, outputC, workArray);
    }

    public static DMatrixRMaj multTransB(DMatrixSparseCSC A2, DMatrixRMaj B, @Nullable DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workArrays) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numRows, B.numRows);
        if (workArrays == null) {
            workArrays = new GrowArray<DGrowArray>(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multTransB(A2, B, outputC, workArrays);
        return outputC;
    }

    public static void multAddTransB(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj outputC, @Nullable GrowArray<DGrowArray> workArrays) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numRows != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (workArrays == null) {
            workArrays = new GrowArray<DGrowArray>(DGrowArray::new);
        }
        ImplMultiplication_MT_DSCC.multAddTransB(A2, B, outputC, workArrays);
    }

    public static DMatrixRMaj multTransAB(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj outputC) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numCols, B.numRows);
        ImplMultiplication_MT_DSCC.multTransAB(A2, B, outputC);
        return outputC;
    }

    public static void multAddTransAB(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj outputC) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numCols != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        ImplMultiplication_MT_DSCC.multAddTransAB(A2, B, outputC);
    }
}

