/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.FGrowArray;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.ops.FSemiRing;
import org.ejml.sparse.csc.misc.ImplCommonOpsWithSemiRing_FSCC;
import org.ejml.sparse.csc.mult.ImplMultiplicationWithSemiRing_FSCC;
import org.jetbrains.annotations.Nullable;

public class CommonOpsWithSemiRing_FSCC {
    public static FMatrixSparseCSC mult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC output, FSemiRing semiRing) {
        return CommonOpsWithSemiRing_FSCC.mult(A2, B, output, semiRing, null, null);
    }

    public static FMatrixSparseCSC mult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC output, FSemiRing semiRing, @Nullable IGrowArray gw, @Nullable FGrowArray gx) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2, A2.numRows, B.numCols);
        ImplMultiplicationWithSemiRing_FSCC.mult(A2, B, output, semiRing, gw, gx);
        return output;
    }

    public static FMatrixRMaj mult(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj output, FSemiRing semiRing) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numRows, B.numCols);
        ImplMultiplicationWithSemiRing_FSCC.mult(A2, B, output, semiRing);
        return output;
    }

    public static void multAdd(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj output, FSemiRing semiRing) {
        if (A2.numRows != output.numRows || B.numCols != output.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, output));
        }
        ImplMultiplicationWithSemiRing_FSCC.multAdd(A2, B, output, semiRing);
    }

    public static FMatrixRMaj multTransA(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj output, FSemiRing semiRing) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numCols, B.numCols);
        ImplMultiplicationWithSemiRing_FSCC.multTransA(A2, B, output, semiRing);
        return output;
    }

    public static void multAddTransA(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj output, FSemiRing semiRing) {
        if (A2.numCols != output.numRows || B.numCols != output.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, output));
        }
        ImplMultiplicationWithSemiRing_FSCC.multAddTransA(A2, B, output, semiRing);
    }

    public static FMatrixRMaj multTransB(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj output, FSemiRing semiRing) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numRows, B.numRows);
        ImplMultiplicationWithSemiRing_FSCC.multTransB(A2, B, output, semiRing);
        return output;
    }

    public static void multAddTransB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj output, FSemiRing semiRing) {
        if (A2.numRows != output.numRows || B.numRows != output.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, output));
        }
        ImplMultiplicationWithSemiRing_FSCC.multAddTransB(A2, B, output, semiRing);
    }

    public static FMatrixRMaj multTransAB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj output, FSemiRing semiRing) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numCols, B.numRows);
        ImplMultiplicationWithSemiRing_FSCC.multTransAB(A2, B, output, semiRing);
        return output;
    }

    public static void multAddTransAB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj C, FSemiRing semiRing) {
        if (A2.numCols != C.numRows || B.numRows != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, C));
        }
        ImplMultiplicationWithSemiRing_FSCC.multAddTransAB(A2, B, C, semiRing);
    }

    public static FMatrixSparseCSC add(float alpha, FMatrixSparseCSC A2, float beta, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC output, FSemiRing semiRing, @Nullable IGrowArray gw, @Nullable FGrowArray gx) {
        if (A2.numRows != B.numRows || A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2, A2.numRows, A2.numCols);
        ImplCommonOpsWithSemiRing_FSCC.add(alpha, A2, beta, B, output, semiRing, gw, gx);
        return output;
    }

    public static FMatrixSparseCSC elementMult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC output, FSemiRing semiRing, @Nullable IGrowArray gw, @Nullable FGrowArray gx) {
        if (A2.numCols != B.numCols || A2.numRows != B.numRows) {
            throw new MatrixDimensionException("All inputs must have the same number of rows and columns. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2, A2.numRows, A2.numCols);
        ImplCommonOpsWithSemiRing_FSCC.elementMult(A2, B, output, semiRing, gw, gx);
        return output;
    }
}

