/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.ops.DSemiRing;
import org.ejml.sparse.csc.misc.ImplCommonOpsWithSemiRing_DSCC;
import org.ejml.sparse.csc.mult.ImplMultiplicationWithSemiRing_DSCC;
import org.jetbrains.annotations.Nullable;

public class CommonOpsWithSemiRing_DSCC {
    public static DMatrixSparseCSC mult(DMatrixSparseCSC A2, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC output, DSemiRing semiRing) {
        return CommonOpsWithSemiRing_DSCC.mult(A2, B, output, semiRing, null, null);
    }

    public static DMatrixSparseCSC mult(DMatrixSparseCSC A2, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC output, DSemiRing semiRing, @Nullable IGrowArray gw, @Nullable DGrowArray gx) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2, A2.numRows, B.numCols);
        ImplMultiplicationWithSemiRing_DSCC.mult(A2, B, output, semiRing, gw, gx);
        return output;
    }

    public static DMatrixRMaj mult(DMatrixSparseCSC A2, DMatrixRMaj B, @Nullable DMatrixRMaj output, DSemiRing semiRing) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numRows, B.numCols);
        ImplMultiplicationWithSemiRing_DSCC.mult(A2, B, output, semiRing);
        return output;
    }

    public static void multAdd(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj output, DSemiRing semiRing) {
        if (A2.numRows != output.numRows || B.numCols != output.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, output));
        }
        ImplMultiplicationWithSemiRing_DSCC.multAdd(A2, B, output, semiRing);
    }

    public static DMatrixRMaj multTransA(DMatrixSparseCSC A2, DMatrixRMaj B, @Nullable DMatrixRMaj output, DSemiRing semiRing) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numCols, B.numCols);
        ImplMultiplicationWithSemiRing_DSCC.multTransA(A2, B, output, semiRing);
        return output;
    }

    public static void multAddTransA(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj output, DSemiRing semiRing) {
        if (A2.numCols != output.numRows || B.numCols != output.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, output));
        }
        ImplMultiplicationWithSemiRing_DSCC.multAddTransA(A2, B, output, semiRing);
    }

    public static DMatrixRMaj multTransB(DMatrixSparseCSC A2, DMatrixRMaj B, @Nullable DMatrixRMaj output, DSemiRing semiRing) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numRows, B.numRows);
        ImplMultiplicationWithSemiRing_DSCC.multTransB(A2, B, output, semiRing);
        return output;
    }

    public static void multAddTransB(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj output, DSemiRing semiRing) {
        if (A2.numRows != output.numRows || B.numRows != output.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, output));
        }
        ImplMultiplicationWithSemiRing_DSCC.multAddTransB(A2, B, output, semiRing);
    }

    public static DMatrixRMaj multTransAB(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj output, DSemiRing semiRing) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2.numCols, B.numRows);
        ImplMultiplicationWithSemiRing_DSCC.multTransAB(A2, B, output, semiRing);
        return output;
    }

    public static void multAddTransAB(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj C, DSemiRing semiRing) {
        if (A2.numCols != C.numRows || B.numRows != C.numCols) {
            throw new IllegalArgumentException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, C));
        }
        ImplMultiplicationWithSemiRing_DSCC.multAddTransAB(A2, B, C, semiRing);
    }

    public static DMatrixSparseCSC add(double alpha, DMatrixSparseCSC A2, double beta, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC output, DSemiRing semiRing, @Nullable IGrowArray gw, @Nullable DGrowArray gx) {
        if (A2.numRows != B.numRows || A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2, A2.numRows, A2.numCols);
        ImplCommonOpsWithSemiRing_DSCC.add(alpha, A2, beta, B, output, semiRing, gw, gx);
        return output;
    }

    public static DMatrixSparseCSC elementMult(DMatrixSparseCSC A2, DMatrixSparseCSC B, @Nullable DMatrixSparseCSC output, DSemiRing semiRing, @Nullable IGrowArray gw, @Nullable DGrowArray gx) {
        if (A2.numCols != B.numCols || A2.numRows != B.numRows) {
            throw new MatrixDimensionException("All inputs must have the same number of rows and columns. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2, A2.numRows, A2.numCols);
        ImplCommonOpsWithSemiRing_DSCC.elementMult(A2, B, output, semiRing, gw, gx);
        return output;
    }
}

