/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple.ops;

import java.io.PrintStream;
import org.ejml.data.Complex_F64;
import org.ejml.data.FGrowArray;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.ConvertToDenseException;
import org.ejml.simple.ConvertToImaginaryException;
import org.ejml.simple.SimpleSparseOperations;
import org.ejml.sparse.csc.CommonOps_FSCC;
import org.ejml.sparse.csc.MatrixFeatures_FSCC;
import org.ejml.sparse.csc.NormOps_FSCC;

public class SimpleOperations_FSCC
implements SimpleSparseOperations<FMatrixSparseCSC, FMatrixRMaj> {
    public transient IGrowArray gw = new IGrowArray();
    public transient FGrowArray gx = new FGrowArray();

    @Override
    public void set(FMatrixSparseCSC A2, int row, int column, double value) {
        A2.set(row, column, (float)value);
    }

    @Override
    public void set(FMatrixSparseCSC A2, int row, int column, double real, double imaginary) {
        throw new ConvertToImaginaryException();
    }

    @Override
    public double get(FMatrixSparseCSC A2, int row, int column) {
        return A2.get(row, column);
    }

    @Override
    public void get(FMatrixSparseCSC A2, int row, int column, Complex_F64 value) {
        value.real = A2.get(row, column);
        value.imaginary = 0.0;
    }

    @Override
    public void fill(FMatrixSparseCSC A2, double value) {
        if (value != 0.0) {
            throw new ConvertToDenseException();
        }
        A2.zero();
    }

    @Override
    public void transpose(FMatrixSparseCSC input, FMatrixSparseCSC output) {
        CommonOps_FSCC.transpose(input, output, this.gw);
    }

    @Override
    public void mult(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        CommonOps_FSCC.mult(A2, B, output);
    }

    @Override
    public void multTransA(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        FMatrixSparseCSC At = new FMatrixSparseCSC(1, 1);
        CommonOps_FSCC.transpose(A2, At, this.gw);
        CommonOps_FSCC.mult(At, B, output, this.gw, this.gx);
    }

    @Override
    public void extractDiag(FMatrixSparseCSC input, FMatrixRMaj output) {
        CommonOps_FSCC.extractDiag(input, output);
    }

    @Override
    public void multTransA(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FSCC.multTransA(A2, B, output, null);
    }

    @Override
    public void mult(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj output) {
        CommonOps_FSCC.mult(A2, B, output);
    }

    @Override
    public void kron(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public void plus(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        CommonOps_FSCC.add(1.0f, A2, 1.0f, B, output, null, null);
    }

    @Override
    public void minus(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        CommonOps_FSCC.add(1.0f, A2, -1.0f, B, output, null, null);
    }

    @Override
    public void minus(FMatrixSparseCSC A2, double b, FMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void plus(FMatrixSparseCSC A2, double b, FMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void plus(FMatrixSparseCSC A2, double beta, FMatrixSparseCSC b, FMatrixSparseCSC output) {
        CommonOps_FSCC.add(1.0f, A2, (float)beta, b, output, this.gw, this.gx);
    }

    @Override
    public void plus(double alpha, FMatrixSparseCSC A2, double beta, FMatrixSparseCSC b, FMatrixSparseCSC output) {
        CommonOps_FSCC.add((float)alpha, A2, (float)beta, b, output, this.gw, this.gx);
    }

    @Override
    public double dot(FMatrixSparseCSC A2, FMatrixSparseCSC v) {
        return CommonOps_FSCC.dotInnerColumns(A2, 0, v, 0, this.gw, this.gx);
    }

    @Override
    public void scale(FMatrixSparseCSC A2, double val2, FMatrixSparseCSC output) {
        CommonOps_FSCC.scale((float)val2, A2, output);
    }

    @Override
    public void divide(FMatrixSparseCSC A2, double val2, FMatrixSparseCSC output) {
        CommonOps_FSCC.divide(A2, (float)val2, output);
    }

    @Override
    public boolean invert(FMatrixSparseCSC A2, FMatrixSparseCSC output) {
        return this.solve(A2, output, CommonOps_FSCC.identity(A2.numRows, A2.numCols));
    }

    @Override
    public void setIdentity(FMatrixSparseCSC A2) {
        CommonOps_FSCC.setIdentity(A2);
    }

    @Override
    public void pseudoInverse(FMatrixSparseCSC A2, FMatrixSparseCSC output) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public boolean solve(FMatrixSparseCSC A2, FMatrixSparseCSC X2, FMatrixSparseCSC B) {
        return CommonOps_FSCC.solve(A2, X2, B);
    }

    @Override
    public boolean solve(FMatrixSparseCSC A2, FMatrixRMaj X2, FMatrixRMaj B) {
        return CommonOps_FSCC.solve(A2, X2, B);
    }

    @Override
    public void zero(FMatrixSparseCSC A2) {
        A2.zero();
    }

    @Override
    public double normF(FMatrixSparseCSC A2) {
        return NormOps_FSCC.normF(A2);
    }

    @Override
    public double conditionP2(FMatrixSparseCSC A2) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public double determinant(FMatrixSparseCSC A2) {
        return CommonOps_FSCC.det(A2);
    }

    @Override
    public double trace(FMatrixSparseCSC A2) {
        return CommonOps_FSCC.trace(A2);
    }

    @Override
    public void setRow(FMatrixSparseCSC A2, int row, int startColumn, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(row, startColumn + i, (float)values[i]);
        }
    }

    @Override
    public void setColumn(FMatrixSparseCSC A2, int column, int startRow, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(startRow + i, column, (float)values[i]);
        }
    }

    @Override
    public void extract(FMatrixSparseCSC src, int srcY0, int srcY1, int srcX0, int srcX1, FMatrixSparseCSC dst, int dstY0, int dstX0) {
        CommonOps_FSCC.extract(src, srcY0, srcY1, srcX0, srcX1, dst, dstY0, dstX0);
    }

    @Override
    public FMatrixSparseCSC diag(FMatrixSparseCSC A2) {
        FMatrixSparseCSC output;
        if (MatrixFeatures_FSCC.isVector(A2)) {
            int N = Math.max(A2.numCols, A2.numRows);
            output = new FMatrixSparseCSC(N, N);
            CommonOps_FSCC.diag(output, A2.nz_values, 0, N);
        } else {
            int N = Math.min(A2.numCols, A2.numRows);
            output = new FMatrixSparseCSC(N, 1);
            CommonOps_FSCC.extractDiag(A2, output);
        }
        return output;
    }

    @Override
    public boolean hasUncountable(FMatrixSparseCSC M) {
        return MatrixFeatures_FSCC.hasUncountable(M);
    }

    @Override
    public void changeSign(FMatrixSparseCSC a) {
        CommonOps_FSCC.changeSign(a, a);
    }

    @Override
    public double elementMaxAbs(FMatrixSparseCSC A2) {
        return CommonOps_FSCC.elementMaxAbs(A2);
    }

    @Override
    public double elementMinAbs(FMatrixSparseCSC A2) {
        return CommonOps_FSCC.elementMinAbs(A2);
    }

    @Override
    public double elementSum(FMatrixSparseCSC A2) {
        return CommonOps_FSCC.elementSum(A2);
    }

    @Override
    public void elementMult(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        CommonOps_FSCC.elementMult(A2, B, output, null, null);
    }

    @Override
    public void elementDiv(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementPower(FMatrixSparseCSC A2, FMatrixSparseCSC B, FMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementPower(FMatrixSparseCSC A2, double b, FMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementExp(FMatrixSparseCSC A2, FMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementLog(FMatrixSparseCSC A2, FMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public boolean isIdentical(FMatrixSparseCSC A2, FMatrixSparseCSC B, double tol) {
        return MatrixFeatures_FSCC.isEqualsSort(A2, B, (float)tol);
    }

    @Override
    public void print(PrintStream out, Matrix mat, String format) {
        MatrixIO.print(out, (FMatrixSparseCSC)mat, format);
    }
}

