/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple.ops;

import java.io.PrintStream;
import org.ejml.data.Complex_F64;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.ConvertToDenseException;
import org.ejml.simple.ConvertToImaginaryException;
import org.ejml.simple.SimpleSparseOperations;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.MatrixFeatures_DSCC;
import org.ejml.sparse.csc.NormOps_DSCC;

public class SimpleOperations_DSCC
implements SimpleSparseOperations<DMatrixSparseCSC, DMatrixRMaj> {
    public transient IGrowArray gw = new IGrowArray();
    public transient DGrowArray gx = new DGrowArray();

    @Override
    public void set(DMatrixSparseCSC A2, int row, int column, double value) {
        A2.set(row, column, value);
    }

    @Override
    public void set(DMatrixSparseCSC A2, int row, int column, double real, double imaginary) {
        throw new ConvertToImaginaryException();
    }

    @Override
    public double get(DMatrixSparseCSC A2, int row, int column) {
        return A2.get(row, column);
    }

    @Override
    public void get(DMatrixSparseCSC A2, int row, int column, Complex_F64 value) {
        value.real = A2.get(row, column);
        value.imaginary = 0.0;
    }

    @Override
    public void fill(DMatrixSparseCSC A2, double value) {
        if (value != 0.0) {
            throw new ConvertToDenseException();
        }
        A2.zero();
    }

    @Override
    public void transpose(DMatrixSparseCSC input, DMatrixSparseCSC output) {
        CommonOps_DSCC.transpose(input, output, this.gw);
    }

    @Override
    public void mult(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        CommonOps_DSCC.mult(A2, B, output);
    }

    @Override
    public void multTransA(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        DMatrixSparseCSC At = new DMatrixSparseCSC(1, 1);
        CommonOps_DSCC.transpose(A2, At, this.gw);
        CommonOps_DSCC.mult(At, B, output, this.gw, this.gx);
    }

    @Override
    public void extractDiag(DMatrixSparseCSC input, DMatrixRMaj output) {
        CommonOps_DSCC.extractDiag(input, output);
    }

    @Override
    public void multTransA(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DSCC.multTransA(A2, B, output, null);
    }

    @Override
    public void mult(DMatrixSparseCSC A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DSCC.mult(A2, B, output);
    }

    @Override
    public void kron(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public void plus(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        CommonOps_DSCC.add(1.0, A2, 1.0, B, output, null, null);
    }

    @Override
    public void minus(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        CommonOps_DSCC.add(1.0, A2, -1.0, B, output, null, null);
    }

    @Override
    public void minus(DMatrixSparseCSC A2, double b, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void plus(DMatrixSparseCSC A2, double b, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void plus(DMatrixSparseCSC A2, double beta, DMatrixSparseCSC b, DMatrixSparseCSC output) {
        CommonOps_DSCC.add(1.0, A2, beta, b, output, this.gw, this.gx);
    }

    @Override
    public void plus(double alpha, DMatrixSparseCSC A2, double beta, DMatrixSparseCSC b, DMatrixSparseCSC output) {
        CommonOps_DSCC.add(alpha, A2, beta, b, output, this.gw, this.gx);
    }

    @Override
    public double dot(DMatrixSparseCSC A2, DMatrixSparseCSC v) {
        return CommonOps_DSCC.dotInnerColumns(A2, 0, v, 0, this.gw, this.gx);
    }

    @Override
    public void scale(DMatrixSparseCSC A2, double val2, DMatrixSparseCSC output) {
        CommonOps_DSCC.scale(val2, A2, output);
    }

    @Override
    public void divide(DMatrixSparseCSC A2, double val2, DMatrixSparseCSC output) {
        CommonOps_DSCC.divide(A2, val2, output);
    }

    @Override
    public boolean invert(DMatrixSparseCSC A2, DMatrixSparseCSC output) {
        return this.solve(A2, output, CommonOps_DSCC.identity(A2.numRows, A2.numCols));
    }

    @Override
    public void setIdentity(DMatrixSparseCSC A2) {
        CommonOps_DSCC.setIdentity(A2);
    }

    @Override
    public void pseudoInverse(DMatrixSparseCSC A2, DMatrixSparseCSC output) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public boolean solve(DMatrixSparseCSC A2, DMatrixSparseCSC X2, DMatrixSparseCSC B) {
        return CommonOps_DSCC.solve(A2, X2, B);
    }

    @Override
    public boolean solve(DMatrixSparseCSC A2, DMatrixRMaj X2, DMatrixRMaj B) {
        return CommonOps_DSCC.solve(A2, X2, B);
    }

    @Override
    public void zero(DMatrixSparseCSC A2) {
        A2.zero();
    }

    @Override
    public double normF(DMatrixSparseCSC A2) {
        return NormOps_DSCC.normF(A2);
    }

    @Override
    public double conditionP2(DMatrixSparseCSC A2) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public double determinant(DMatrixSparseCSC A2) {
        return CommonOps_DSCC.det(A2);
    }

    @Override
    public double trace(DMatrixSparseCSC A2) {
        return CommonOps_DSCC.trace(A2);
    }

    @Override
    public void setRow(DMatrixSparseCSC A2, int row, int startColumn, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(row, startColumn + i, values[i]);
        }
    }

    @Override
    public void setColumn(DMatrixSparseCSC A2, int column, int startRow, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(startRow + i, column, values[i]);
        }
    }

    @Override
    public void extract(DMatrixSparseCSC src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrixSparseCSC dst, int dstY0, int dstX0) {
        CommonOps_DSCC.extract(src, srcY0, srcY1, srcX0, srcX1, dst, dstY0, dstX0);
    }

    @Override
    public DMatrixSparseCSC diag(DMatrixSparseCSC A2) {
        DMatrixSparseCSC output;
        if (MatrixFeatures_DSCC.isVector(A2)) {
            int N = Math.max(A2.numCols, A2.numRows);
            output = new DMatrixSparseCSC(N, N);
            CommonOps_DSCC.diag(output, A2.nz_values, 0, N);
        } else {
            int N = Math.min(A2.numCols, A2.numRows);
            output = new DMatrixSparseCSC(N, 1);
            CommonOps_DSCC.extractDiag(A2, output);
        }
        return output;
    }

    @Override
    public boolean hasUncountable(DMatrixSparseCSC M) {
        return MatrixFeatures_DSCC.hasUncountable(M);
    }

    @Override
    public void changeSign(DMatrixSparseCSC a) {
        CommonOps_DSCC.changeSign(a, a);
    }

    @Override
    public double elementMaxAbs(DMatrixSparseCSC A2) {
        return CommonOps_DSCC.elementMaxAbs(A2);
    }

    @Override
    public double elementMinAbs(DMatrixSparseCSC A2) {
        return CommonOps_DSCC.elementMinAbs(A2);
    }

    @Override
    public double elementSum(DMatrixSparseCSC A2) {
        return CommonOps_DSCC.elementSum(A2);
    }

    @Override
    public void elementMult(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        CommonOps_DSCC.elementMult(A2, B, output, null, null);
    }

    @Override
    public void elementDiv(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementPower(DMatrixSparseCSC A2, DMatrixSparseCSC B, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementPower(DMatrixSparseCSC A2, double b, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementExp(DMatrixSparseCSC A2, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public void elementLog(DMatrixSparseCSC A2, DMatrixSparseCSC output) {
        throw new ConvertToDenseException();
    }

    @Override
    public boolean isIdentical(DMatrixSparseCSC A2, DMatrixSparseCSC B, double tol) {
        return MatrixFeatures_DSCC.isEqualsSort(A2, B, tol);
    }

    @Override
    public void print(PrintStream out, Matrix mat, String format) {
        MatrixIO.print(out, (DMatrixSparseCSC)mat, format);
    }
}

