/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple.ops;

import java.io.PrintStream;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.SimpleOperations;

public class SimpleOperations_DDRM
implements SimpleOperations<DMatrixRMaj> {
    @Override
    public void set(DMatrixRMaj A2, int row, int column, double value) {
        A2.set(row, column, value);
    }

    @Override
    public void set(DMatrixRMaj A2, int row, int column, double real, double imaginary) {
        throw new IllegalArgumentException("Does not support imaginary values");
    }

    @Override
    public double get(DMatrixRMaj A2, int row, int column) {
        return A2.get(row, column);
    }

    @Override
    public void get(DMatrixRMaj A2, int row, int column, Complex_F64 value) {
        value.real = A2.get(row, column);
        value.imaginary = 0.0;
    }

    @Override
    public void fill(DMatrixRMaj A2, double value) {
        CommonOps_DDRM.fill(A2, value);
    }

    @Override
    public void transpose(DMatrixRMaj input, DMatrixRMaj output) {
        CommonOps_DDRM.transpose(input, output);
    }

    @Override
    public void mult(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.mult(A2, B, output);
    }

    @Override
    public void multTransA(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.multTransA(A2, B, output);
    }

    @Override
    public void kron(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.kron(A2, B, output);
    }

    @Override
    public void plus(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.add(A2, B, output);
    }

    @Override
    public void minus(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.subtract(A2, B, output);
    }

    @Override
    public void minus(DMatrixRMaj A2, double b, DMatrixRMaj output) {
        CommonOps_DDRM.subtract(A2, b, output);
    }

    @Override
    public void plus(DMatrixRMaj A2, double b, DMatrixRMaj output) {
        CommonOps_DDRM.add(A2, b, output);
    }

    @Override
    public void plus(DMatrixRMaj A2, double beta, DMatrixRMaj b, DMatrixRMaj output) {
        CommonOps_DDRM.add(A2, beta, b, output);
    }

    @Override
    public void plus(double alpha, DMatrixRMaj A2, double beta, DMatrixRMaj b, DMatrixRMaj output) {
        CommonOps_DDRM.add(alpha, A2, beta, b, output);
    }

    @Override
    public double dot(DMatrixRMaj A2, DMatrixRMaj v) {
        return VectorVectorMult_DDRM.innerProd(A2, v);
    }

    @Override
    public void scale(DMatrixRMaj A2, double val2, DMatrixRMaj output) {
        CommonOps_DDRM.scale(val2, A2, output);
    }

    @Override
    public void divide(DMatrixRMaj A2, double val2, DMatrixRMaj output) {
        CommonOps_DDRM.divide(A2, val2, output);
    }

    @Override
    public boolean invert(DMatrixRMaj A2, DMatrixRMaj output) {
        return CommonOps_DDRM.invert(A2, output);
    }

    @Override
    public void setIdentity(DMatrixRMaj A2) {
        CommonOps_DDRM.setIdentity(A2);
    }

    @Override
    public void pseudoInverse(DMatrixRMaj A2, DMatrixRMaj output) {
        CommonOps_DDRM.pinv(A2, output);
    }

    @Override
    public boolean solve(DMatrixRMaj A2, DMatrixRMaj X2, DMatrixRMaj B) {
        return CommonOps_DDRM.solve(A2, B, X2);
    }

    @Override
    public void zero(DMatrixRMaj A2) {
        A2.zero();
    }

    @Override
    public double normF(DMatrixRMaj A2) {
        return NormOps_DDRM.normF(A2);
    }

    @Override
    public double conditionP2(DMatrixRMaj A2) {
        return NormOps_DDRM.conditionP2(A2);
    }

    @Override
    public double determinant(DMatrixRMaj A2) {
        return CommonOps_DDRM.det(A2);
    }

    @Override
    public double trace(DMatrixRMaj A2) {
        return CommonOps_DDRM.trace(A2);
    }

    @Override
    public void setRow(DMatrixRMaj A2, int row, int startColumn, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(row, startColumn + i, values[i]);
        }
    }

    @Override
    public void setColumn(DMatrixRMaj A2, int column, int startRow, double ... values) {
        for (int i = 0; i < values.length; ++i) {
            A2.set(startRow + i, column, values[i]);
        }
    }

    @Override
    public void extract(DMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrixRMaj dst, int dstY0, int dstX0) {
        CommonOps_DDRM.extract(src, srcY0, srcY1, srcX0, srcX1, dst, dstY0, dstX0);
    }

    @Override
    public DMatrixRMaj diag(DMatrixRMaj A2) {
        DMatrixRMaj output;
        if (MatrixFeatures_DDRM.isVector(A2)) {
            int N = Math.max(A2.numCols, A2.numRows);
            output = new DMatrixRMaj(N, N);
            CommonOps_DDRM.diag(output, N, A2.data);
        } else {
            int N = Math.min(A2.numCols, A2.numRows);
            output = new DMatrixRMaj(N, 1);
            CommonOps_DDRM.extractDiag(A2, output);
        }
        return output;
    }

    @Override
    public boolean hasUncountable(DMatrixRMaj M) {
        return MatrixFeatures_DDRM.hasUncountable(M);
    }

    @Override
    public void changeSign(DMatrixRMaj a) {
        CommonOps_DDRM.changeSign(a);
    }

    @Override
    public double elementMaxAbs(DMatrixRMaj A2) {
        return CommonOps_DDRM.elementMaxAbs(A2);
    }

    @Override
    public double elementMinAbs(DMatrixRMaj A2) {
        return CommonOps_DDRM.elementMinAbs(A2);
    }

    @Override
    public double elementSum(DMatrixRMaj A2) {
        return CommonOps_DDRM.elementSum(A2);
    }

    @Override
    public void elementMult(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.elementMult(A2, B, output);
    }

    @Override
    public void elementDiv(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.elementDiv(A2, B, output);
    }

    @Override
    public void elementPower(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj output) {
        CommonOps_DDRM.elementPower(A2, B, output);
    }

    @Override
    public void elementPower(DMatrixRMaj A2, double b, DMatrixRMaj output) {
        CommonOps_DDRM.elementPower(A2, b, output);
    }

    @Override
    public void elementExp(DMatrixRMaj A2, DMatrixRMaj output) {
        CommonOps_DDRM.elementExp(A2, output);
    }

    @Override
    public void elementLog(DMatrixRMaj A2, DMatrixRMaj output) {
        CommonOps_DDRM.elementLog(A2, output);
    }

    @Override
    public boolean isIdentical(DMatrixRMaj A2, DMatrixRMaj B, double tol) {
        return MatrixFeatures_DDRM.isIdentical(A2, B, tol);
    }

    @Override
    public void print(PrintStream out, Matrix mat, String format) {
        MatrixIO.print(out, (DMatrixRMaj)mat, format);
    }
}

