/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.misc;

import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.FMatrix1Row;

public class TransposeAlgs_MT_FDRM {
    public static void square(FMatrix1Row A2) {
        EjmlConcurrency.loopFor(0, A2.numRows, i -> {
            int index = i * A2.numCols + i + 1;
            int indexEnd = (i + 1) * A2.numCols;
            int indexOther = (i + 1) * A2.numCols + i;
            while (index < indexEnd) {
                float val2 = A2.data[index];
                A2.data[index] = A2.data[indexOther];
                A2.data[indexOther] = val2;
                ++index;
                indexOther += A2.numCols;
            }
        });
    }

    public static void block(FMatrix1Row A2, FMatrix1Row A_tran, int blockLength) {
        EjmlConcurrency.loopBlocks(0, A2.numRows, blockLength, (idx0, idx1) -> {
            int blockHeight = idx1 - idx0;
            int indexSrc = idx0 * A2.numCols;
            int indexDst = idx0;
            for (int j = 0; j < A2.numCols; j += blockLength) {
                int blockWidth = Math.min(blockLength, A2.numCols - j);
                int indexSrcEnd = indexSrc + blockWidth;
                while (indexSrc < indexSrcEnd) {
                    int rowSrc = indexSrc;
                    int rowDst = indexDst;
                    int end = rowDst + blockHeight;
                    while (rowDst < end) {
                        A_tran.data[rowDst++] = A2.data[rowSrc];
                        rowSrc += A2.numCols;
                    }
                    indexDst += A_tran.numCols;
                    ++indexSrc;
                }
            }
        });
    }

    public static void standard(FMatrix1Row A2, FMatrix1Row A_tran) {
        EjmlConcurrency.loopFor(0, A_tran.numRows, i -> {
            int index = i * A_tran.numCols;
            int index2 = i;
            int end = index + A_tran.numCols;
            while (index < end) {
                A_tran.data[index++] = A2.data[index2];
                index2 += A2.numCols;
            }
        });
    }
}

