/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.misc;

import org.ejml.data.DMatrix1Row;

public class TransposeAlgs_DDRM {
    public static void square(DMatrix1Row A2) {
        for (int i = 0; i < A2.numRows; ++i) {
            int index = i * A2.numCols + i + 1;
            int indexEnd = (i + 1) * A2.numCols;
            int indexOther = (i + 1) * A2.numCols + i;
            while (index < indexEnd) {
                double val2 = A2.data[index];
                A2.data[index] = A2.data[indexOther];
                A2.data[indexOther] = val2;
                ++index;
                indexOther += A2.numCols;
            }
        }
    }

    public static void block(DMatrix1Row A2, DMatrix1Row A_tran, int blockLength) {
        for (int idx0 = 0; idx0 < A2.numRows; idx0 += blockLength) {
            int idx1 = Math.min(A2.numRows, idx0 + blockLength);
            int blockHeight = idx1 - idx0;
            int indexSrc = idx0 * A2.numCols;
            int indexDst = idx0;
            for (int j = 0; j < A2.numCols; j += blockLength) {
                int blockWidth = Math.min(blockLength, A2.numCols - j);
                int indexSrcEnd = indexSrc + blockWidth;
                while (indexSrc < indexSrcEnd) {
                    int rowSrc = indexSrc;
                    int rowDst = indexDst;
                    int end = rowDst + blockHeight;
                    while (rowDst < end) {
                        A_tran.data[rowDst++] = A2.data[rowSrc];
                        rowSrc += A2.numCols;
                    }
                    indexDst += A_tran.numCols;
                    ++indexSrc;
                }
            }
        }
    }

    public static void standard(DMatrix1Row A2, DMatrix1Row A_tran) {
        for (int i = 0; i < A_tran.numRows; ++i) {
            int index = i * A_tran.numCols;
            int index2 = i;
            int end = index + A_tran.numCols;
            while (index < end) {
                A_tran.data[index++] = A2.data[index2];
                index2 += A2.numCols;
            }
        }
    }
}

