/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.misc;

import org.ejml.data.FMatrixRMaj;
import org.ejml.interfaces.linsol.ReducedRowEchelonForm_F32;

public class RrefGaussJordanRowPivot_FDRM
implements ReducedRowEchelonForm_F32<FMatrixRMaj> {
    float tol;

    @Override
    public void setTolerance(float tol) {
        this.tol = tol;
    }

    @Override
    public void reduce(FMatrixRMaj A2, int coefficientColumns) {
        if (A2.numCols < coefficientColumns) {
            throw new IllegalArgumentException("The system must be at least as wide as A");
        }
        int leadIndex = 0;
        for (int i = 0; i < coefficientColumns; ++i) {
            int row;
            int pivotRow = -1;
            float maxValue = this.tol;
            for (row = leadIndex; row < A2.numRows; ++row) {
                float v = Math.abs(A2.data[row * A2.numCols + i]);
                if (!(v > maxValue)) continue;
                maxValue = v;
                pivotRow = row;
            }
            if (pivotRow == -1) continue;
            if (leadIndex != pivotRow) {
                RrefGaussJordanRowPivot_FDRM.swapRows(A2, leadIndex, pivotRow);
            }
            for (row = 0; row < A2.numRows; ++row) {
                if (row == leadIndex) continue;
                int indexPivot = leadIndex * A2.numCols + i;
                int indexTarget = row * A2.numCols + i;
                float alpha = A2.data[indexTarget] / A2.data[indexPivot++];
                A2.data[indexTarget++] = 0.0f;
                for (int col = i + 1; col < A2.numCols; ++col) {
                    int n = indexTarget++;
                    A2.data[n] = A2.data[n] - A2.data[indexPivot++] * alpha;
                }
            }
            int indexPivot = leadIndex * A2.numCols + i;
            float alpha = 1.0f / A2.data[indexPivot];
            A2.data[indexPivot++] = 1.0f;
            for (int col = i + 1; col < A2.numCols; ++col) {
                int n = indexPivot++;
                A2.data[n] = A2.data[n] * alpha;
            }
            ++leadIndex;
        }
    }

    protected static void swapRows(FMatrixRMaj A2, int rowA, int rowB) {
        int indexA = rowA * A2.numCols;
        int indexB = rowB * A2.numCols;
        int i = 0;
        while (i < A2.numCols) {
            float temp = A2.data[indexA];
            A2.data[indexA] = A2.data[indexB];
            A2.data[indexB] = temp;
            ++i;
            ++indexA;
            ++indexB;
        }
    }
}

